/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecEvaluateForwardBusiService;
import com.tydic.uec.busi.bo.UecEvaluateForwardBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateForwardBusiRspBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.EvaForwardRecMapper;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.po.EvaForwardRecPO;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecEvaluateForwardBusiServiceImpl
implements UecEvaluateForwardBusiService {
    private final EvaMapper evaMapper;
    private final EvaForwardRecMapper evaForwardRecMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateForwardBusiServiceImpl(EvaMapper evaMapper, EvaForwardRecMapper evaForwardRecMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.evaMapper = evaMapper;
        this.evaForwardRecMapper = evaForwardRecMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateForwardBusiRspBO dealEvaluateForward(UecEvaluateForwardBusiReqBO reqBO) {
        UecEvaluateForwardBusiRspBO rspBO = new UecEvaluateForwardBusiRspBO();
        EvaPO evaPO = this.evaMapper.getModelById(reqBO.getEvaId());
        if (evaPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8bc4\u4ef7\u8f6c\u53d1\u5931\u8d25\uff0c\u8bc4\u4ef7\u4e0d\u5b58\u5728[evaId=" + reqBO.getEvaId() + "]");
            return rspBO;
        }
        if (UecCommonConstant.ForwardEnum.NO.value.equals(evaPO.getIsForward())) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8bc4\u4ef7\u8f6c\u53d1\u5931\u8d25\uff0c\u8be5\u8bc4\u4ef7\u4e0d\u5141\u8bb8\u8f6c\u53d1");
            return rspBO;
        }
        EvaForwardRecPO insertForwardPO = new EvaForwardRecPO();
        BeanUtils.copyProperties((Object)reqBO.getEvaForwardRec(), (Object)insertForwardPO);
        insertForwardPO.setId(this.generateIdUtil.nextId());
        insertForwardPO.setEvaId(reqBO.getEvaId());
        if (insertForwardPO.getIsAnonymous() == null) {
            insertForwardPO.setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        this.evaForwardRecMapper.insert(insertForwardPO);
        this.redisUtil.del("uec_eva_detail_" + evaPO.getSysCode() + evaPO.getBusiSn(), "uec_eva_detail_" + evaPO.getSysCode() + "_busiSn#" + evaPO.getBusiSn());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u8f6c\u53d1\u6210\u529f");
        return rspBO;
    }
}

