/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tydic.uec.busi.UecTemplateOperateBusiService;
import com.tydic.uec.busi.bo.UecTemplateOperateBusiReqBO;
import com.tydic.uec.busi.bo.UecTemplateOperateBusiRspBO;
import com.tydic.uec.common.bo.mod.ConfBaseFieldBO;
import com.tydic.uec.common.bo.mod.ConfStarItemBO;
import com.tydic.uec.common.bo.mod.TemplateBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.ConfBaseFieldMapper;
import com.tydic.uec.dao.ConfEvaModMapper;
import com.tydic.uec.dao.ConfItemLevelMapper;
import com.tydic.uec.dao.ConfStarItemMapper;
import com.tydic.uec.dao.po.ConfBaseFieldPO;
import com.tydic.uec.dao.po.ConfEvaModPO;
import com.tydic.uec.dao.po.ConfItemLevelPO;
import com.tydic.uec.dao.po.ConfStarItemPO;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UecTemplateOperateBusiServiceImpl
implements UecTemplateOperateBusiService {
    private static final String NEED_STAR_INFO = "needStarInfo";
    private final RedisUtil redisUtil;
    private final UecGenerateIdUtil generateIdUtil;
    private final ConfEvaModMapper confEvaModMapper;
    private final ConfBaseFieldMapper confBaseFieldMapper;
    private final ConfStarItemMapper confStarItemMapper;
    private final ConfItemLevelMapper confItemLevelMapper;

    public UecTemplateOperateBusiServiceImpl(RedisUtil redisUtil, UecGenerateIdUtil generateIdUtil, ConfEvaModMapper confEvaModMapper, ConfBaseFieldMapper confBaseFieldMapper, ConfStarItemMapper confStarItemMapper, ConfItemLevelMapper confItemLevelMapper) {
        this.redisUtil = redisUtil;
        this.generateIdUtil = generateIdUtil;
        this.confEvaModMapper = confEvaModMapper;
        this.confBaseFieldMapper = confBaseFieldMapper;
        this.confStarItemMapper = confStarItemMapper;
        this.confItemLevelMapper = confItemLevelMapper;
    }

    @Override
    public UecTemplateOperateBusiRspBO dealTemplateOperate(UecTemplateOperateBusiReqBO reqBO) {
        this.invalidPreMode(reqBO);
        if (UecCommonConstant.OperateType.INSERT.equals(reqBO.getOperateType())) {
            this.handleTemplateInsert(reqBO);
        } else if (UecCommonConstant.OperateType.UPDATE.equals(reqBO.getOperateType())) {
            this.handleTemplateUpdate(reqBO);
        } else if (UecCommonConstant.OperateType.DELETE.equals(reqBO.getOperateType())) {
            this.handleTemplateValid(reqBO.getTemplateInfo());
        }
        UecTemplateOperateBusiRspBO rspBO = new UecTemplateOperateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6a21\u677f\u4fe1\u606f\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    private void invalidPreMode(UecTemplateOperateBusiReqBO reqBO) {
        ConfEvaModPO confEvaModPO;
        ConfEvaModPO po = new ConfEvaModPO();
        po.setTypeCode(reqBO.getTemplateInfo().getTypeCode());
        if (StringUtils.isEmpty((Object)reqBO.getTemplateInfo().getTypeCode()) && StringUtils.hasText((String)reqBO.getTemplateInfo().getModId()) && null != (confEvaModPO = this.confEvaModMapper.getModelById(Long.valueOf(reqBO.getTemplateInfo().getModId())))) {
            po.setTypeCode(confEvaModPO.getTypeCode());
        }
        po.setState(UecCommonConstant.StateEnum.YES.value);
        po.setSysCode(reqBO.getTemplateInfo().getSysCode());
        if (StringUtils.hasText((String)reqBO.getTemplateInfo().getModId())) {
            po.setModId(Long.valueOf(reqBO.getTemplateInfo().getModId()));
        }
        if (UecCommonConstant.OperateType.DELETE.equals(reqBO.getOperateType()) && reqBO.getTemplateInfo().getState().equals(UecCommonConstant.StateEnum.YES.value)) {
            ConfEvaModPO tempResult = this.confEvaModMapper.getModelById(Long.valueOf(reqBO.getTemplateInfo().getModId()));
            po.setSysCode(tempResult.getSysCode());
            po.setTypeCode(tempResult.getTypeCode());
            ConfEvaModPO result = this.confEvaModMapper.getInvalidPreMode(po);
            if (result != null) {
                throw new BusinessException("\u5931\u8d25", "\u5df2\u5b58\u5728\u76f8\u540c\u4e14\u5df2\u542f\u7528\u7684\u6a21\u677f\uff0c\u8bf7\u5148\u505c\u7528\u5df2\u542f\u7528\u7684\u6a21\u677f\uff01");
            }
        } else {
            this.confEvaModMapper.updateInvalidPreMode(po);
        }
    }

    private void handleTemplateInsert(UecTemplateOperateBusiReqBO reqBO) {
        long modId = this.generateIdUtil.nextId();
        ConfEvaModPO insertMod = new ConfEvaModPO();
        BeanUtils.copyProperties((Object)reqBO.getTemplateInfo(), (Object)insertMod);
        insertMod.setModId(modId);
        this.confEvaModMapper.insert(insertMod);
        if (!CollectionUtils.isEmpty(reqBO.getBaseFieldList())) {
            this.generateDetailInfo(reqBO.getBaseFieldList(), modId, insertMod.getCreateOperId());
        }
    }

    private void handleTemplateUpdate(UecTemplateOperateBusiReqBO reqBO) {
        long modId = Long.parseLong(reqBO.getTemplateInfo().getModId());
        ConfEvaModPO qryParam = new ConfEvaModPO();
        qryParam.setModCode(reqBO.getTemplateInfo().getModCode());
        qryParam.setTypeCode(reqBO.getTemplateInfo().getTypeCode());
        qryParam.setSysCode(reqBO.getTemplateInfo().getSysCode());
        List<ConfEvaModPO> checkList = this.confEvaModMapper.getList(qryParam);
        if (!(CollectionUtils.isEmpty(checkList) || checkList.size() <= 1 && modId == checkList.get(0).getModId())) {
            throw new BusinessException("4002", "\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u7cfb\u7edf[sysCode]\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b[typeCode,modCode]\u7684\u8bc4\u4ef7\u6a21\u677f");
        }
        ConfEvaModPO updateMod = new ConfEvaModPO();
        BeanUtils.copyProperties((Object)reqBO.getTemplateInfo(), (Object)updateMod);
        updateMod.setModId(modId);
        updateMod.setUpdateOperId(reqBO.getTemplateInfo().getUpdateOperId());
        this.confEvaModMapper.updateById(updateMod);
        if (!CollectionUtils.isEmpty(reqBO.getBaseFieldList())) {
            ConfBaseFieldPO deleteField = new ConfBaseFieldPO();
            deleteField.setModId(modId);
            this.confBaseFieldMapper.deleteBy(deleteField);
            ConfStarItemPO deleteStar = new ConfStarItemPO();
            deleteStar.setModId(modId);
            List<ConfStarItemPO> startList = this.confStarItemMapper.getList(deleteStar);
            this.confStarItemMapper.deleteBy(deleteStar);
            if (!CollectionUtils.isEmpty(startList)) {
                this.confItemLevelMapper.deleteByItemIds(startList.stream().map(ConfStarItemPO::getItemId).collect(Collectors.toList()));
            }
            this.generateDetailInfo(reqBO.getBaseFieldList(), modId, updateMod.getUpdateOperId());
        }
        this.redisUtil.del("uec_mod_detail_" + modId);
    }

    private void handleTemplateValid(TemplateBO templateInfo) {
        long modId = Long.parseLong(templateInfo.getModId());
        ConfEvaModPO updateMod = new ConfEvaModPO();
        updateMod.setModId(modId);
        updateMod.setState(templateInfo.getState());
        updateMod.setUpdateOperId(templateInfo.getUpdateOperId());
        this.confEvaModMapper.updateById(updateMod);
        if (UecCommonConstant.StateEnum.NO.value.equals(templateInfo.getState())) {
            this.redisUtil.del("uec_mod_detail_" + modId);
        }
    }

    private void generateDetailInfo(List<ConfBaseFieldBO> baseFieldList, long modId, String createOper) {
        ArrayList insertFieldList = Lists.newArrayListWithExpectedSize((int)baseFieldList.size());
        ArrayList insertStarList = Lists.newArrayListWithExpectedSize((int)baseFieldList.size());
        ArrayList insertLevelList = Lists.newArrayListWithExpectedSize((int)(baseFieldList.size() * 5));
        for (int fieldSort = 0; fieldSort < baseFieldList.size(); ++fieldSort) {
            ConfBaseFieldBO fieldBO = baseFieldList.get(fieldSort);
            ConfBaseFieldPO insertField = new ConfBaseFieldPO();
            BeanUtils.copyProperties((Object)fieldBO, (Object)insertField);
            insertField.setId(this.generateIdUtil.nextId());
            insertField.setModId(modId);
            insertField.setSort(fieldSort);
            insertField.setCreateOperId(createOper);
            insertField.setStarRatingDescription(fieldBO.getStarRatingDescription());
            if (!CollectionUtils.isEmpty((Collection)fieldBO.getStarItemList())) {
                HashMap param = Maps.newHashMap();
                param.put(NEED_STAR_INFO, UecCommonConstant.YES_FLAG.toString());
                insertField.setApiInParam(JSON.toJSONString((Object)param));
                int starSort = 0;
                for (ConfStarItemBO starBO : fieldBO.getStarItemList()) {
                    ConfStarItemPO insertStar = new ConfStarItemPO();
                    BeanUtils.copyProperties((Object)starBO, (Object)insertStar);
                    insertStar.setItemId(this.generateIdUtil.nextId());
                    insertStar.setModId(modId);
                    insertStar.setSort(starSort);
                    insertStar.setCreateOperId(createOper);
                    if (insertStar.getIsDefault() == null) {
                        insertStar.setIsDefault(0);
                    }
                    ++starSort;
                    insertStarList.add(insertStar);
                    starBO.getItemLevelList().sort(Comparator.naturalOrder());
                    for (int levelSort = 0; levelSort < starBO.getItemLevelList().size(); ++levelSort) {
                        ConfItemLevelPO insertLevel = new ConfItemLevelPO();
                        BeanUtils.copyProperties(starBO.getItemLevelList().get(levelSort), (Object)insertLevel);
                        insertLevel.setId(this.generateIdUtil.nextId());
                        insertLevel.setItemId(insertStar.getItemId());
                        insertLevel.setItemCode(insertStar.getItemCode());
                        insertLevel.setSort(levelSort);
                        insertLevel.setCreateOperId(createOper);
                        insertLevelList.add(insertLevel);
                    }
                }
            }
            insertFieldList.add(insertField);
        }
        if (insertFieldList.size() > 0) {
            this.confBaseFieldMapper.insertBatch(insertFieldList);
        }
        if (insertStarList.size() > 0) {
            this.confStarItemMapper.insertBatch(insertStarList);
        }
        if (insertLevelList.size() > 0) {
            this.confItemLevelMapper.insertBatch(insertLevelList);
        }
    }
}

