/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.google.common.collect.Lists;
import com.tydic.uec.ability.UecEvaluateCreateAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateCreateBusiService;
import com.tydic.uec.busi.UecEvaluateRecordBusiService;
import com.tydic.uec.busi.UecTemplateDetailQryBusiService;
import com.tydic.uec.busi.bo.UecEvaluateCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateCreateBusiRspBO;
import com.tydic.uec.busi.bo.UecEvaluateRecordBusiReqBO;
import com.tydic.uec.busi.bo.UecTemplateDetailQryBusiReqBO;
import com.tydic.uec.busi.bo.UecTemplateDetailQryBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaBaseInfoBO;
import com.tydic.uec.common.bo.eva.EvaExtBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.common.bo.eva.EvaObjInfoBO;
import com.tydic.uec.common.bo.eva.EvaPicBO;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import com.tydic.uec.common.bo.mod.ConfBaseFieldBO;
import com.tydic.uec.common.bo.mod.ConfItemLevelBO;
import com.tydic.uec.common.bo.mod.ConfStarItemBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecEvaluateCreateAbilityService"})
public class UecEvaluateCreateAbilityServiceImpl
implements UecEvaluateCreateAbilityService {
    @Autowired
    private UecEvaluateCreateBusiService uecEvaluateCreateBusiService;
    @Autowired
    private UecEvaluateRecordBusiService uecEvaluateRecordBusiService;
    @Autowired
    private UecTemplateDetailQryBusiService uecTemplateDetailQryBusiService;
    @Value(value="${createLableFlag:false}")
    private boolean createLableFlag;

    @PostMapping(value={"createEvaluate"})
    public UecEvaluateCreateAbilityRspBO createEvaluate(@RequestBody UecEvaluateCreateAbilityReqBO reqBO) {
        if (reqBO.getMemIdExt() != null) {
            if (reqBO.getEvaBaseInfo() == null) {
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u57fa\u672c\u4fe1\u606f[evaBaseInfo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqBO.getEvaBaseInfo().setMemId(reqBO.getMemIdExt().toString());
            reqBO.getEvaBaseInfo().setMemName(reqBO.getName());
            reqBO.getEvaBaseInfo().setIpAddr(reqBO.getIpAddrExt());
        }
        this.validArgs(reqBO);
        List<UecEvaluateCreateBusiReqBO> busiReqList = this.generateBusiParam(reqBO);
        ArrayList evaIds = Lists.newArrayList();
        String respCode = "0000";
        StringBuilder respDesc = new StringBuilder();
        for (UecEvaluateCreateBusiReqBO busiReqBO : busiReqList) {
            UecEvaluateCreateBusiRspBO busiRspBO = this.uecEvaluateCreateBusiService.createEvaluate(busiReqBO);
            respDesc.append(busiReqBO.getEvaBaseInfo().getObjName());
            if ("0000".equals(busiRspBO.getRespCode())) {
                evaIds.add(busiRspBO.getEvaId());
                respDesc.append("\u8bc4\u4ef7\u521b\u5efa\u6210\u529f");
                if (this.createLableFlag) {
                    this.createLable(busiReqBO, busiRspBO);
                }
            } else {
                respCode = "4011";
                respDesc.append("\u8bc4\u4ef7\u521b\u5efa\u5931\u8d25:").append(busiRspBO.getRespDesc());
            }
            respDesc.append("\uff1b\\r\\n\\t");
        }
        UecEvaluateCreateAbilityRspBO rspBO = new UecEvaluateCreateAbilityRspBO();
        rspBO.setEvaIds((List)evaIds);
        rspBO.setRespCode(respCode);
        rspBO.setRespDesc(respDesc.toString());
        return rspBO;
    }

    private void createLable(UecEvaluateCreateBusiReqBO busiReqBO, UecEvaluateCreateBusiRspBO busiRspBO) {
        if ("EVA".equals(busiReqBO.getEvaBaseInfo().getTypeCode())) {
            UecEvaluateRecordBusiReqBO uecEvaluateRecordBusiReqBO = new UecEvaluateRecordBusiReqBO();
            uecEvaluateRecordBusiReqBO.setRecordType(UecCommonConstant.StatsType.LABEL);
            uecEvaluateRecordBusiReqBO.setSysCode(busiReqBO.getEvaBaseInfo().getSysCode());
            uecEvaluateRecordBusiReqBO.setEvaId(busiRspBO.getEvaId());
            uecEvaluateRecordBusiReqBO.setObjId(busiReqBO.getEvaBaseInfo().getObjId());
            uecEvaluateRecordBusiReqBO.setObjType(busiReqBO.getEvaBaseInfo().getObjType());
            UecTemplateDetailQryBusiReqBO uecTemplateDetailQryBusiReqBO = new UecTemplateDetailQryBusiReqBO();
            uecTemplateDetailQryBusiReqBO.setTypeCode(busiReqBO.getEvaBaseInfo().getTypeCode());
            uecTemplateDetailQryBusiReqBO.setModId(busiReqBO.getEvaBaseInfo().getModId());
            UecTemplateDetailQryBusiRspBO templateDetailQryBusiRspBO = this.uecTemplateDetailQryBusiService.qryTemplateDetail(uecTemplateDetailQryBusiReqBO);
            ConfBaseFieldBO confBaseField = (ConfBaseFieldBO)templateDetailQryBusiRspBO.getBaseFieldList().stream().filter(confBaseFieldBO -> "product_eva".equals(confBaseFieldBO.getFieldCode())).collect(Collectors.toList()).get(0);
            ConfStarItemBO confStarItem = (ConfStarItemBO)confBaseField.getStarItemList().stream().filter(confStarItemBO -> "product_eva".equals(confStarItemBO.getItemCode())).collect(Collectors.toList()).get(0);
            Map<String, ConfItemLevelBO> confItemLevelBOMap = confStarItem.getItemLevelList().stream().collect(Collectors.toMap(ConfItemLevelBO::getLevelValue, o -> o));
            EvaStarLevelBO evaStarLevel = (EvaStarLevelBO)busiReqBO.getStarLevelList().stream().filter(evaStarLevelBO -> "product_eva".equals(evaStarLevelBO.getItemCode())).collect(Collectors.toList()).get(0);
            ConfItemLevelBO confItemLevelBO = confItemLevelBOMap.get(evaStarLevel.getLevelValue());
            EvaLabelBO labelBO = new EvaLabelBO();
            labelBO.setLabelCode(confItemLevelBO.getLevelValue());
            labelBO.setLabelName(confItemLevelBO.getLevelDesc());
            labelBO.setLabelDesc(confItemLevelBO.getLevelDesc());
            uecEvaluateRecordBusiReqBO.setLabelList(Collections.singletonList(labelBO));
            this.uecEvaluateRecordBusiService.dealDataRecord(uecEvaluateRecordBusiReqBO);
        }
    }

    private void validArgs(UecEvaluateCreateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (reqBO.getEvaBaseInfo() == null) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u57fa\u672c\u4fe1\u606f[evaBaseInfo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEvaBaseInfo().getSysCode())) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u7cfb\u7edf[evaBaseInfo.sysCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjInfoList())) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u5bf9\u8c61\u4fe1\u606f[objInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validObjInfoList(reqBO.getObjInfoList());
        if (reqBO.getEvaBaseInfo().getIsAudit() == null) {
            reqBO.getEvaBaseInfo().setIsAudit(UecCommonConstant.YES_FLAG);
        }
        if (reqBO.getEvaBaseInfo().getIsContentHide() == null) {
            reqBO.getEvaBaseInfo().setIsContentHide(UecCommonConstant.FieldHideEnum.NO.value);
        }
        if (reqBO.getNeedAudit().booleanValue()) {
            reqBO.getEvaBaseInfo().setEvaState(UecCommonConstant.StateEnum.APPROVING.value);
        } else {
            reqBO.getEvaBaseInfo().setEvaState(UecCommonConstant.StateEnum.YES.value);
        }
        if (reqBO.getEvaBaseInfo().getReviewLen() == null) {
            reqBO.getEvaBaseInfo().setReviewLen(Integer.valueOf(0));
        }
        if (reqBO.getEvaBaseInfo().getPostLen() == null) {
            reqBO.getEvaBaseInfo().setPostLen(Integer.valueOf(0));
        }
        Field[] fields = reqBO.getEvaBaseInfo().getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                if ("objType".equals(field.getName()) || !"java.lang.Integer".equals(field.getGenericType().getTypeName())) continue;
                field.setAccessible(true);
                if (field.get(reqBO.getEvaBaseInfo()) != null) continue;
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u57fa\u672c\u4fe1\u606f[evaBaseInfo." + field.getName() + "]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (IllegalAccessException e) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", e);
        }
        if ((UecCommonConstant.EvaAct.ADD_EVALUATE.equals(reqBO.getEvaBaseInfo().getEvaAct()) || UecCommonConstant.EvaAct.SHOW.equals(reqBO.getEvaBaseInfo().getEvaAct())) && reqBO.getEvaBaseInfo().getUpperEvaId() == null) {
            throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u4e0a\u7ea7\u8bc4\u4ef7ID[evaBaseInfo.upperEvaId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtList())) {
            for (EvaExtBO evaExt : reqBO.getExtList()) {
                if (!StringUtils.isBlank((CharSequence)evaExt.getFieldCode())) continue;
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u5c5e\u6027\u7f16\u7801[extList.fieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validObjInfoList(List<EvaObjInfoBO> objInfoList) {
        for (EvaObjInfoBO evaObjInfoBO : objInfoList) {
            if (evaObjInfoBO.getObjType() == null) {
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u5bf9\u8c61\u7c7b\u578b[objInfoList.objType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)evaObjInfoBO.getObjId())) {
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u4ef7\u5bf9\u8c61ID[objInfoList.objId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)evaObjInfoBO.getStarLevelList())) {
                for (EvaStarLevelBO evaStarLevel : evaObjInfoBO.getStarLevelList()) {
                    if (StringUtils.isBlank((CharSequence)evaStarLevel.getItemCode())) {
                        throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u8bc4\u661f\u9879\u7f16\u7801[objInfoList.starLevelList.itemCode]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)evaStarLevel.getLevelValue())) {
                        throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u661f\u7ea7\u503c[objInfoList.starLevelList.levelValue]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (evaStarLevel.getIsDefault() != null) continue;
                    throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u9ed8\u8ba4\u8bc4\u661f\u9879[objInfoList.starLevelList.isDefault]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (CollectionUtils.isEmpty((Collection)evaObjInfoBO.getPicList())) continue;
            for (EvaPicBO evaPic : evaObjInfoBO.getPicList()) {
                if (StringUtils.isBlank((CharSequence)evaPic.getPicUrl())) {
                    throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u56fe\u7247URL[objInfoList.picList.picUrl]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (evaPic.getPicType() != null) continue;
                throw new BusinessException("4444", "\u521b\u5efa\u8bc4\u4ef7\u670d\u52a1\u56fe\u7247\u7c7b\u578b[objInfoList.picList.picType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private List<UecEvaluateCreateBusiReqBO> generateBusiParam(UecEvaluateCreateAbilityReqBO reqBO) {
        ArrayList busiReqList = Lists.newArrayList();
        for (EvaObjInfoBO evaObjInfoBO : reqBO.getObjInfoList()) {
            UecEvaluateCreateBusiReqBO busiReqBO = new UecEvaluateCreateBusiReqBO();
            EvaBaseInfoBO evaBaseInfo = new EvaBaseInfoBO();
            BeanUtils.copyProperties((Object)reqBO.getEvaBaseInfo(), (Object)evaBaseInfo);
            evaBaseInfo.setMemId(reqBO.getUserId().toString());
            evaBaseInfo.setMemName(reqBO.getName());
            busiReqBO.setEvaBaseInfo(evaBaseInfo);
            busiReqBO.setExtList(reqBO.getExtList());
            busiReqBO.getEvaBaseInfo().setObjId(evaObjInfoBO.getObjId());
            busiReqBO.getEvaBaseInfo().setObjName(evaObjInfoBO.getObjName());
            busiReqBO.getEvaBaseInfo().setObjType(evaObjInfoBO.getObjType());
            busiReqBO.setEvaContent(evaObjInfoBO.getEvaContent());
            busiReqBO.setStarLevelList(evaObjInfoBO.getStarLevelList());
            busiReqBO.setPicList(evaObjInfoBO.getPicList());
            busiReqBO.setUserId(reqBO.getUserId());
            busiReqBO.setName(reqBO.getName());
            busiReqBO.setOrgId(reqBO.getOrgId());
            busiReqBO.setOrgName(reqBO.getOrgName());
            busiReqList.add(busiReqBO);
        }
        return busiReqList;
    }
}

