/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.commonmenu;

import com.tydic.dyc.authority.model.commonmenu.ISysCommonMenuModel;
import com.tydic.dyc.authority.model.commonmenu.SysCommonMenuDo;
import com.tydic.dyc.authority.model.commonmenu.qrybo.SysCommonMenuHistoryQryBo;
import com.tydic.dyc.authority.service.commonmenu.AuthGetCommonMenuRecentListService;
import com.tydic.dyc.authority.service.commonmenu.bo.AuthGetCommonMenuRecentListReqBo;
import com.tydic.dyc.authority.service.commonmenu.bo.AuthGetCommonMenuRecentListRspBo;
import com.tydic.dyc.authority.service.commonmenu.bo.CommonMenuHistoryBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.commonmenu.AuthGetCommonMenuRecentListService"})
public class AuthGetCommonMenuRecentListServiceImpl
implements AuthGetCommonMenuRecentListService {
    @Autowired
    private ISysCommonMenuModel iSysCommonMenuModel;
    @Value(value="${COMMON_MENU_RECENT_MAX_SIZE:15}")
    private Integer MAX_SIZE;

    @PostMapping(value={"qryRecentMenuList"})
    public AuthGetCommonMenuRecentListRspBo qryRecentMenuList(@RequestBody AuthGetCommonMenuRecentListReqBo reqBo) {
        AuthGetCommonMenuRecentListRspBo rspBo = AuthRu.success(AuthGetCommonMenuRecentListRspBo.class);
        this.validateArg(reqBo);
        SysCommonMenuHistoryQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysCommonMenuHistoryQryBo.class));
        qryBo.setMaxSize(this.MAX_SIZE);
        qryBo.setOrderBy("create_time");
        SysCommonMenuDo commonMenuHistoryList = this.iSysCommonMenuModel.getCommonMenuHistoryList(qryBo);
        rspBo.setRecentMenuList(AuthRu.jsl(commonMenuHistoryList.getSysCommonMenuHistorySubDoList(), CommonMenuHistoryBo.class));
        return rspBo;
    }

    private void validateArg(AuthGetCommonMenuRecentListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

