/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryRspBo;
import com.tydic.dyc.authority.service.domainservice.AuthBatchGetUserPowerRoleListService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthBatchGetUserPowerRoleBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthBatchGetUserPowerRoleListReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthBatchGetUserPowerRoleListRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoListRspBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.domainservice.AuthBatchGetUserPowerRoleListService"})
public class AuthBatchGetUserPowerRoleListServiceImpl
implements AuthBatchGetUserPowerRoleListService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel UmcEnterpriseInfoModel;

    @PostMapping(value={"getUserPowerRoleListBatch"})
    public AuthBatchGetUserPowerRoleListRspBo getUserPowerRoleListBatch(@RequestBody AuthBatchGetUserPowerRoleListReqBo reqBo) {
        AuthBatchGetUserPowerRoleListRspBo rspBo = AuthRu.success(AuthBatchGetUserPowerRoleListRspBo.class);
        this.validateArg(reqBo);
        UmcUserInfoQryBo operUserReqBo = new UmcUserInfoQryBo();
        operUserReqBo.setUserIds(reqBo.getUserIdList());
        UmcUserInfoListRspBo sysUserInfoListRspBo = this.iUmcUserInfoModel.getUserList(operUserReqBo);
        if (CollectionUtils.isEmpty((Collection)sysUserInfoListRspBo.getRows())) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f");
        }
        ArrayList<AuthBatchGetUserPowerRoleBo> userRoleList = new ArrayList<AuthBatchGetUserPowerRoleBo>();
        List<Integer> disAgFlagList = Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
        for (UmcUserInfoDo operInfoDo : sysUserInfoListRspBo.getRows()) {
            AuthBatchGetUserPowerRoleBo authBatchGetUserPowerRoleBo = new AuthBatchGetUserPowerRoleBo();
            authBatchGetUserPowerRoleBo.setUserId(operInfoDo.getUserId());
            if ("auth:system:manage".equals(operInfoDo.getAuthorityType())) {
                SysRoleInfoQryBo roleQryBo = new SysRoleInfoQryBo();
                roleQryBo.setIsSystemManager("1");
                roleQryBo.setPageSize(-1);
                SysRoleInfoQryRspBo powerRoleList = this.iSysRoleInfoModel.getRolePageList(roleQryBo);
                authBatchGetUserPowerRoleBo.setRoleNameList(powerRoleList.getRows().stream().map(SysRoleInfoDo::getRoleName).collect(Collectors.toList()));
            } else {
                UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
                userInfoQryBo.setUserId(operInfoDo.getUserId());
                userInfoQryBo.setDisAgFLagList(disAgFlagList);
                UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getRoleInfoListByUser(userInfoQryBo);
                List<SysRoleInfoDo> powerRoleList = AuthRu.jsl(userInfoDo.getUserRoleList(), SysRoleInfoDo.class);
                UmcEnterpriseInfoQryBo orgRoleInfo = new UmcEnterpriseInfoQryBo();
                orgRoleInfo.setOrgTreePath(operInfoDo.getOrgTreePath());
                orgRoleInfo.setDisAgFLagList(disAgFlagList);
                orgRoleInfo.setPageSize(-1);
                UmcEnterpriseInfoDo orgInfoDo = this.UmcEnterpriseInfoModel.getRoleInfoListByOrg(orgRoleInfo);
                List<SysRoleInfoDo> orgRoleList = AuthRu.jsl(orgInfoDo.getOrgRoleList(), SysRoleInfoDo.class);
                Set roleNames = powerRoleList.stream().map(SysRoleInfoDo::getRoleName).collect(Collectors.toSet());
                roleNames.addAll(orgRoleList.stream().map(SysRoleInfoDo::getRoleName).collect(Collectors.toSet()));
                authBatchGetUserPowerRoleBo.setRoleNameList(new ArrayList(roleNames));
            }
            userRoleList.add(authBatchGetUserPowerRoleBo);
        }
        rspBo.setUserRoleList(userRoleList);
        return rspBo;
    }

    private void validateArg(AuthBatchGetUserPowerRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserPowerRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthRoleInfoBo> getUserRoleList(UmcUserInfoDo targetUserDo) {
        UmcEnterpriseInfoQryBo orgQryBo = new UmcEnterpriseInfoQryBo();
        orgQryBo.setOrgTreePath(targetUserDo.getOrgTreePath());
        orgQryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        UmcEnterpriseInfoDo orgInfoDo = this.UmcEnterpriseInfoModel.getRoleInfoListByOrg(orgQryBo);
        Map orgRoleMaps = orgInfoDo.getOrgRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity()));
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(targetUserDo.getUserId());
        userInfoQryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getRoleInfoListByUser(userInfoQryBo);
        Map userRolemaps = userInfoDo.getUserRoleList().stream().collect(Collectors.toMap(SysRoleInfoSubDo::getRoleId, Function.identity(), (e1, e2) -> e2));
        HashMap allUserRoleMap = new HashMap();
        allUserRoleMap.putAll(userRolemaps);
        allUserRoleMap.putAll(orgRoleMaps);
        ArrayList rspDoList = new ArrayList();
        allUserRoleMap.keySet().forEach(key -> rspDoList.add(allUserRoleMap.get(key)));
        return AuthRu.jsl(rspDoList, AuthRoleInfoBo.class);
    }
}

