/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.service.domainservice.AuthGetOrgTreeByRoleService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetOrgTreeByRoleReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetOrgTreeByRoleRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRolePworOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.domainservice.AuthGetOrgTreeByRoleService"})
public class AuthGetOrgTreeByRoleServiceImpl
implements AuthGetOrgTreeByRoleService {
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getOrgTreeByTreePathList"})
    public AuthGetOrgTreeByRoleRspBo getOrgTreeByTreePathList(@RequestBody AuthGetOrgTreeByRoleReqBo reqBo) {
        UmcEnterpriseInfoDo distributeDo = AuthRu.js(reqBo, UmcEnterpriseInfoDo.class);
        List listByRole = this.iSysOrgInfoModel.getList(distributeDo).getRows();
        List<AuthRolePworOrgInfoBo> jsl = AuthRu.jsl(listByRole, AuthRolePworOrgInfoBo.class);
        List<AuthRolePworOrgInfoBo> buildByRecursive = null;
        if (listByRole.size() > 0) {
            buildByRecursive = this.buildByRecursive(jsl);
        }
        AuthGetOrgTreeByRoleRspBo rspBo = new AuthGetOrgTreeByRoleRspBo();
        rspBo.setOrgTrees(buildByRecursive);
        return rspBo;
    }

    private List<AuthRolePworOrgInfoBo> buildByRecursive(List<AuthRolePworOrgInfoBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthRolePworOrgInfoBo> trees = new ArrayList<AuthRolePworOrgInfoBo>();
        for (AuthRolePworOrgInfoBo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthRolePworOrgInfoBo findChildren(AuthRolePworOrgInfoBo root, List<AuthRolePworOrgInfoBo> allMenus) {
        for (AuthRolePworOrgInfoBo it : allMenus) {
            if (!root.getOrgId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

