/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.subpage.ISysSubpageModel;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageQryBo;
import com.tydic.dyc.authority.model.subpage.qrybo.SysSubpageRspBo;
import com.tydic.dyc.authority.service.menu.AuthCreateMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthCreateMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthCreateMenuRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.menu.AuthCreateMenuService"})
public class AuthCreateMenuServiceImpl
implements AuthCreateMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysSubpageModel iSysSubpageModel;

    @PostMapping(value={"createMenu"})
    public AuthCreateMenuRspBo createMenu(@RequestBody AuthCreateMenuReqBo reqBo) {
        AuthCreateMenuRspBo rspBo = AuthRu.success(AuthCreateMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo menuQryBo = new SysMenuQryBo();
        menuQryBo.setMenuCode(reqBo.getMenuCode());
        List menuList = this.iSysMenuModel.getMenuList(menuQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)menuList)) {
            throw new BaseBusinessException("100001", "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        SysSubpageQryBo subpageQryBo = new SysSubpageQryBo();
        subpageQryBo.setPageCode(reqBo.getMenuCode());
        SysSubpageRspBo subpageList = this.iSysSubpageModel.getSubpageList(subpageQryBo);
        if (!CollectionUtils.isEmpty((Collection)subpageList.getRows())) {
            throw new BaseBusinessException("100001", "\u5b50\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        SysMenuQryBo parentQryBo = new SysMenuQryBo();
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setMenuId(IdUtil.nextId());
        if (reqBo.getParentId() != null) {
            parentQryBo.setMenuId(reqBo.getParentId());
            SysMenuDo parent = this.iSysMenuModel.getMenuInfoDetails(parentQryBo);
            if (parent == null || parent.getMenuId() == null) {
                throw new BaseBusinessException("100001", "\u7236\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728");
            }
            reqDo.setMenuTreePath(parent.getMenuTreePath() + reqDo.getMenuId() + "-");
            reqDo.setDeep(parent.getDeep() + 1);
        } else {
            reqDo.setMenuTreePath("-" + reqDo.getMenuId() + "-");
            reqDo.setDeep(1);
        }
        SysMenuDo rspDo = this.iSysMenuModel.createMenuInfo(reqDo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthCreateMenuReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setMenuStatus("1");
        SysMenuDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysMenuDo.class));
        return reqDo;
    }

    private void validateArg(AuthCreateMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

