/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthDeleteMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthDeleteMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthDeleteMenuRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.menu.AuthDeleteMenuService"})
public class AuthDeleteMenuServiceImpl
implements AuthDeleteMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"deleteMenu"})
    public AuthDeleteMenuRspBo deleteMenu(@RequestBody AuthDeleteMenuReqBo reqBo) {
        AuthDeleteMenuRspBo rspBo = AuthRu.success(AuthDeleteMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setDelFlag("1");
        SysMenuQryBo qryBo = new SysMenuQryBo();
        ArrayList<Long> menuIds = new ArrayList<Long>();
        if (reqBo.getMenuId() != null) {
            menuIds.add(reqBo.getMenuId());
        } else {
            menuIds.addAll(reqBo.getMenuIds());
        }
        reqDo.setMenuIds(menuIds);
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(reqDo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthDeleteMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        return reqDo;
    }

    private void validateArg(AuthDeleteMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() == null && CollectionUtils.isEmpty((Collection)reqBo.getMenuIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId\u6216MenuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

