/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthEnableMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthEnableMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthEnableMenuRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.menu.AuthEnableMenuService"})
public class AuthEnableMenuServiceImpl
implements AuthEnableMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"enableMenu"})
    public AuthEnableMenuRspBo enableMenu(@RequestBody AuthEnableMenuReqBo reqBo) {
        AuthEnableMenuRspBo rspBo = AuthRu.success(AuthEnableMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuQryBo qryBo = new SysMenuQryBo();
        qryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo rspDoDetail = this.iSysMenuModel.getMenuInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        if ("1".equals(rspDoDetail.getMenuStatus())) {
            return rspBo;
        }
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(reqDo);
        AuthMenuInfoBo DoToBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(DoToBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthEnableMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        reqDo.setMenuStatus("1");
        return reqDo;
    }

    private void validateArg(AuthEnableMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

