/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.role.AuthCreateRoleInfoService;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthCreateRoleInfoService"})
public class AuthCreateRoleInfoServiceImpl
implements AuthCreateRoleInfoService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;
    private static final long ROOT_ORG_ID = 1L;

    @PostMapping(value={"createRoleInfo"})
    public AuthCreateRoleInfoRspBo createRoleInfo(@RequestBody AuthCreateRoleInfoReqBo reqBo) {
        AuthCreateRoleInfoRspBo rspBo = AuthRu.success(AuthCreateRoleInfoRspBo.class);
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        if (reqBo.getOrgIdIn() != 1L && !CollectionUtils.isEmpty((Collection)reqBo.getOrgIdList()) && !reqBo.getOrgIdList().contains(reqBo.getOrgIdIn())) {
            reqBo.getOrgIdList().add(reqBo.getOrgIdIn());
        }
        SysRoleInfoDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setRoleId(IdUtil.nextId());
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.createRoleInfo(reqDo);
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        rspBo.setRoleInfoBo(DoToBo);
        return rspBo;
    }

    private SysRoleInfoDo buildDoByBO(AuthCreateRoleInfoReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        reqDo.setManageLevel(reqBo.getManagerLevelIn());
        return reqDo;
    }

    private void validateArg(AuthCreateRoleInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void getManageLevel(AuthCreateRoleInfoReqBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            UmcEnterpriseInfoQryBo orgInfoQryBo = new UmcEnterpriseInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            UmcEnterpriseInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }
}

