/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysRoleRolePowerSubDo;
import com.tydic.dyc.authority.service.role.AuthDealRolePowerService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRolePowerReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRolePowerRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthRolePowerBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthDealRolePowerService"})
public class AuthDealRolePowerServiceImpl
implements AuthDealRolePowerService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"dealRolePower"})
    public AuthDealRolePowerRspBo dealRolePower(@RequestBody AuthDealRolePowerReqBo reqBo) {
        AuthDealRolePowerRspBo rspBo = AuthRu.success(AuthDealRolePowerRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryListBo = new SysRoleInfoQryBo();
        qryListBo.setRoleId(reqBo.getRoleId());
        SysRoleInfoDo oldRoleDo = this.iSysRoleInfoModel.getRolePowerList(qryListBo);
        List<SysRoleRolePowerSubDo> oldDoList = oldRoleDo.getRolePowerList();
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        List<SysRoleRolePowerSubDo> newDoList = reqDo.getRolePowerList();
        ArrayList<SysRoleRolePowerSubDo> eqaulsOld = new ArrayList<SysRoleRolePowerSubDo>();
        ArrayList<SysRoleRolePowerSubDo> eqaulsNew = new ArrayList<SysRoleRolePowerSubDo>();
        block0: for (SysRoleRolePowerSubDo oldDo : oldDoList) {
            for (SysRoleRolePowerSubDo newDo : newDoList) {
                if (!oldDo.getPowerRoleId().equals(newDo.getPowerRoleId())) continue;
                eqaulsNew.add(newDo);
                eqaulsOld.add(oldDo);
                continue block0;
            }
        }
        oldDoList.removeAll(eqaulsOld);
        newDoList.removeAll(eqaulsNew);
        this.deleteRolePower(reqDo, oldDoList);
        this.addRolePower(reqDo, newDoList);
        return rspBo;
    }

    private void addRolePower(SysRoleInfoDo reqDo, List<SysRoleRolePowerSubDo> newDoList) {
        SysRoleInfoDo addReqBo = new SysRoleInfoDo();
        for (SysRoleRolePowerSubDo subDo : newDoList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setRolePowerList(newDoList);
        this.iSysRoleInfoModel.addRolePower(addReqBo);
    }

    private void deleteRolePower(SysRoleInfoDo reqDo, List<SysRoleRolePowerSubDo> oldDoList) {
        SysRoleInfoDo deleteDo = new SysRoleInfoDo();
        for (SysRoleRolePowerSubDo subDo : oldDoList) {
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        deleteDo.setRolePowerList(oldDoList);
        this.iSysRoleInfoModel.updateRolePower(deleteDo);
    }

    private void validateArg(AuthDealRolePowerReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getRolePowerList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getRolePowerList())) {
            for (AuthRolePowerBo bo : reqBo.getRolePowerList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

