/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.role.AuthDeleteRoleInfoService;
import com.tydic.dyc.authority.service.role.bo.AuthDeleteRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDeleteRoleInfoRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthDeleteRoleInfoService"})
public class AuthDeleteRoleInfoServiceImpl
implements AuthDeleteRoleInfoService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"deleteRoleInfo"})
    public AuthDeleteRoleInfoRspBo deleteRoleInfo(@RequestBody AuthDeleteRoleInfoReqBo reqBo) {
        AuthDeleteRoleInfoRspBo rspBo = AuthRu.success(AuthDeleteRoleInfoRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(reqBo.getRoleId());
        SysRoleInfoDo rspDoDetail = this.iSysRoleInfoModel.getRoleInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u89d2\u8272\u4fe1\u606f");
        }
        if ("1".equals(rspDoDetail.getDelFlag())) {
            return rspBo;
        }
        SysRoleInfoDo reqDo = this.buildDoByBO(reqBo);
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.modifyRoleInfo(reqDo);
        SysRoleInfoDo deleteRoleMenuBtnByRole = this.iSysRoleInfoModel.deleteRoleMenuBtnByRole(reqDo);
        SysRoleInfoDo deleteRoleMenuDataOrg = this.iSysRoleInfoModel.deleteRoleMenuDataOrg(reqDo);
        SysRoleInfoDo deleteRoleMenuDataAuth = this.iSysRoleInfoModel.deleteRoleMenuDataAuth(reqDo);
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        rspBo.setRoleInfoBo(DoToBo);
        return rspBo;
    }

    private SysRoleInfoDo buildDoByBO(AuthDeleteRoleInfoReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteRoleInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

