/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.qrybo.SysOrgInfoQryRspBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.role.AuthDistributeListQryService;
import com.tydic.dyc.authority.service.role.bo.AuthDistributeListQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDistributeListQryRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthDistributeListQryService"})
public class AuthDistributeListQryServiceImpl
implements AuthDistributeListQryService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"getAuthDistributeListQry"})
    public AuthDistributeListQryRspBo getAuthDistributeListQry(@RequestBody AuthDistributeListQryReqBo reqBo) {
        AuthDistributeListQryRspBo rspBo = new AuthDistributeListQryRspBo();
        this.validateArg(reqBo);
        SysRoleInfoQryBo infoDo = new SysRoleInfoQryBo();
        infoDo.setOrgId(reqBo.getOrgId());
        if (!StringUtils.isEmpty((Object)reqBo.getRoleId())) {
            infoDo.setRoleId(reqBo.getRoleId());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getDisAgFlag())) {
            infoDo.setDisAgFlag(reqBo.getDisAgFlag());
        }
        SysOrgInfoQryRspBo roleInfoDo = this.iSysRoleInfoModel.getCheckDistributeList(infoDo);
        List<AuthOrgInfoBo> authDistributeInfoBoList = AuthRu.jsl(roleInfoDo.getRows(), AuthOrgInfoBo.class);
        rspBo.setAuthOrgInfoBoList(authDistributeInfoBoList);
        return rspBo;
    }

    private void validateArg(AuthDistributeListQryReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDistributeListQryReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

