/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.tenant;

import com.tydic.dyc.authority.model.tenant.ISysTenantModel;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantApplicationRelQryBo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoQryBo;
import com.tydic.dyc.authority.service.tenant.AuthGetTenantApplicationListService;
import com.tydic.dyc.authority.service.tenant.bo.AuthGetTenantApplicationListReqBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthGetTenantApplicationListRspBo;
import com.tydic.dyc.authority.service.tenant.bo.AuthTenantApplicationRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.tenant.AuthGetTenantApplicationListService"})
public class AuthGetTenantApplicationListServiceImpl
implements AuthGetTenantApplicationListService {
    @Autowired
    private ISysTenantModel iSysTenantModel;

    @PostMapping(value={"getTenantApplicationList"})
    public AuthGetTenantApplicationListRspBo getTenantApplicationList(@RequestBody AuthGetTenantApplicationListReqBo reqBo) {
        AuthGetTenantApplicationListRspBo rspBo = AuthRu.success(AuthGetTenantApplicationListRspBo.class);
        this.validateArg(reqBo);
        SysTenantInfoQryBo qryBo = new SysTenantInfoQryBo();
        qryBo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo rspDoDetail = this.iSysTenantModel.getTenantInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        SysTenantApplicationRelQryBo qryListDo = new SysTenantApplicationRelQryBo();
        qryListDo.setTenantId(reqBo.getTenantId());
        SysTenantInfoDo rspDo = this.iSysTenantModel.getTenantApplicationRelList(qryListDo);
        List<AuthTenantApplicationRelBo> DoToBo = AuthRu.jsl(rspDo.getSysApplicationSubDos(), AuthTenantApplicationRelBo.class);
        rspBo.setTenantApplicationBoList(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetTenantApplicationListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateTenantInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[TenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

