/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthDealUserRoleService;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcAdmUserQryBo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.user.AuthDealUserRoleService"})
public class AuthDealUserRoleServiceImpl
implements AuthDealUserRoleService {
    private static final Logger log = LoggerFactory.getLogger(AuthDealUserRoleServiceImpl.class);
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;

    @PostMapping(value={"dealUserRole"})
    public AuthDealUserRoleRspBo dealUserRole(@RequestBody AuthDealUserRoleReqBo reqBo) {
        AuthDealUserRoleRspBo rspBo = AuthRu.success(AuthDealUserRoleRspBo.class);
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        UmcUserInfoDo reqDo = AuthRu.js(reqBo, UmcUserInfoDo.class);
        UmcUserInfoQryBo qryBo = new UmcUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        UmcUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        this.setOrgInfo(reqDo, userInfoDo);
        qryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        UmcUserInfoDo userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(qryBo);
        List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getUserRoleList();
        List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
        ArrayList<Long> equalsRoleIds = new ArrayList<Long>();
        List oldRoleIds = oldRoleList.stream().map(SysRoleInfoSubDo::getRoleId).collect(Collectors.toList());
        for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
            if (!oldRoleIds.contains(reqDistributeSubDo.getRoleId())) continue;
            equalsRoleIds.add(reqDistributeSubDo.getRoleId());
        }
        oldRoleList.removeIf(i -> equalsRoleIds.contains(i.getRoleId()));
        addSubDo.removeIf(i -> equalsRoleIds.contains(i.getRoleId()));
        this.addUserRole(reqDo, addSubDo, reqBo);
        this.deleteUserRole(reqDo, oldRoleList);
        this.addDistributRoles(reqBo, reqDo, addSubDo);
        return rspBo;
    }

    private void setOrgInfo(UmcUserInfoDo reqDo, UmcUserInfoDo userInfoDo) {
        if (CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            return;
        }
        UmcEnterpriseInfoQryBo orgInfoQryBo = new UmcEnterpriseInfoQryBo();
        orgInfoQryBo.setOrgId(userInfoDo.getOrgId());
        UmcEnterpriseInfoDo sysOrgInfoDo = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
        if (null != sysOrgInfoDo) {
            reqDo.getAuthDistributeList().forEach(sysAuthDistributeSubDo -> {
                sysAuthDistributeSubDo.setOrgId(sysOrgInfoDo.getOrgId());
                sysAuthDistributeSubDo.setOrgTreePath(sysOrgInfoDo.getOrgTreePath());
            });
        }
    }

    private void addDistributRoles(AuthDealUserRoleReqBo reqBo, UmcUserInfoDo reqDo, List<SysAuthDistributeSubDo> addSubDo) {
        UmcAdmUserQryBo admUserQryBo = new UmcAdmUserQryBo();
        admUserQryBo.setUserId(reqBo.getUserId());
        List admOrgList = this.iSysUserInfoModel.getAdmOrgList(admUserQryBo).getRows();
        if (!CollectionUtils.isEmpty((Collection)admOrgList)) {
            SysRoleInfoDo addReqBo = new SysRoleInfoDo();
            ArrayList<SysAuthDistributeSubDo> addAdmList = new ArrayList<SysAuthDistributeSubDo>();
            for (SysAuthDistributeSubDo subDo : addSubDo) {
                if ("0".equals(subDo.getRoleType())) continue;
                SysAuthDistributeSubDo addDo = new SysAuthDistributeSubDo();
                addDo.setAuthId(IdUtil.nextId());
                addDo.setManageLevel(reqBo.getManagerLevelIn());
                addDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                addDo.setRoleId(subDo.getRoleId());
                addDo.setCreateOperId(reqDo.getUpdateOperId());
                addDo.setCreateOperName(reqDo.getUpdateOperName());
                addDo.setCreateTime(reqDo.getUpdateTime());
                addDo.setUpdateOperId(reqDo.getUpdateOperId());
                addDo.setUpdateOperName(reqDo.getUpdateOperName());
                addDo.setUpdateTime(reqDo.getUpdateTime());
                addDo.setUserId(reqBo.getUserId());
                addAdmList.add(addDo);
            }
            addReqBo.setAuthDistributeList(addAdmList);
            this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
        }
    }

    private void addUserRole(UmcUserInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList, AuthDealUserRoleReqBo reqBo) {
        UmcUserInfoDo addReqBo = new UmcUserInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            subDo.setManageLevel(reqBo.getManagerLevelIn());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysUserInfoModel.addUserRoleList(addReqBo);
    }

    private void deleteUserRole(UmcUserInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        UmcUserInfoDo addReqBo = new UmcUserInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setAuthId(roleSubDo.getAuthId());
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysUserInfoModel.updateUserRoleList(addReqBo);
    }

    private void validateArg(AuthDealUserRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealUserRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }

    private void getManageLevel(AuthDealUserRoleReqBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            UmcEnterpriseInfoQryBo orgInfoQryBo = new UmcEnterpriseInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            UmcEnterpriseInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }
}

