/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.service.user.AuthDeleteThirdBindService;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteThirdBindReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDeleteThirdBindRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthThirdBindBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.SysThirdBindQryBo;
import com.tydic.dyc.umc.model.user.sub.SysThirdBindSubDo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.user.AuthDeleteThirdBindService"})
public class AuthDeleteThirdBindServiceImpl
implements AuthDeleteThirdBindService {
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"deleteThirdBind"})
    public AuthDeleteThirdBindRspBo deleteThirdBind(@RequestBody AuthDeleteThirdBindReqBo reqBo) {
        AuthDeleteThirdBindRspBo rspBo = AuthRu.success(AuthDeleteThirdBindRspBo.class);
        this.validateArg(reqBo);
        SysThirdBindSubDo reqDo = this.buildDoByBO(reqBo);
        SysThirdBindQryBo bindQryBo = AuthRu.js(reqBo, SysThirdBindQryBo.class);
        UmcUserInfoDo sysUserInfoDo = this.iSysUserInfoModel.getThirdBindList(bindQryBo);
        if (CollectionUtils.isEmpty(sysUserInfoDo.getSysThirdBindSubDos())) {
            return rspBo;
        }
        SysThirdBindSubDo rspDo = this.iSysUserInfoModel.updateThirdBind(reqDo);
        AuthThirdBindBo DoToBo = AuthRu.js(rspDo, AuthThirdBindBo.class);
        rspBo.setThirdBindBo(DoToBo);
        return rspBo;
    }

    private SysThirdBindSubDo buildDoByBO(AuthDeleteThirdBindReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysThirdBindSubDo reqDo = AuthRu.js(reqBo, SysThirdBindSubDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteThirdBindReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteThirdBindReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuthId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthIdId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getAuthType() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[custId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

