/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.user.AuthGetUserRoleListService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.user.AuthGetUserRoleListService"})
public class AuthGetUserRoleListServiceImpl
implements AuthGetUserRoleListService {
    @Autowired
    private IUmcUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getUserRoleList"})
    public AuthGetUserRoleListRspBo getUserRoleList(@RequestBody AuthGetUserRoleListReqBo reqBo) {
        AuthGetUserRoleListRspBo rspBo = AuthRu.success(AuthGetUserRoleListRspBo.class);
        this.validateArg(reqBo);
        UmcUserInfoQryBo qryBo = new UmcUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        UmcUserInfoDo rspDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (rspDo == null || rspDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcUserInfoQryBo roleQryBo = new UmcUserInfoQryBo();
        roleQryBo.setUserId(rspDo.getUserId());
        UmcUserInfoDo roleInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(roleQryBo);
        List<AuthRoleInfoBo> roleBoList = AuthRu.jsl(roleInfoDo.getUserRoleList(), AuthRoleInfoBo.class);
        rspBo.setRoleInfoBoList(roleBoList);
        return rspBo;
    }

    private void validateArg(AuthGetUserRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

