/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.model.enterpriseapply.UmcEnterpriseInfoApplyDo;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseBankApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseContactApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseExtMapApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcEnterpriseInvoiceApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgInfoApply;
import com.tydic.dyc.umc.model.enterpriseapply.sub.UmcOrgTagRelApply;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.SysAuthDistributeDo;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.model.userapply.IUmcUserInfoApplyModel;
import com.tydic.dyc.umc.model.userapply.UmcUserInfoApplyDo;
import com.tydic.dyc.umc.model.userapply.sub.UmcCustInfoApply;
import com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRspBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcRegisterAccountBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseBankApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseContactApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseExtMapApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseInvoiceApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgInfoApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgTagRelApplyBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserExtMapBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcCustInfoApplyBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcUserTagRelApplyBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService"})
public class UmcEnterpriseUserRegisterServiceImpl
implements UmcEnterpriseUserRegisterService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcUserInfoApplyModel iUmcUserInfoApplyModel;
    @Autowired
    private IUmcEnterpriseAccountModel iUmcEnterpriseAccountModel;

    @PostMapping(value={"dealEnterpriseUserRegister"})
    public UmcEnterpriseUserRegisterRspBo dealEnterpriseUserRegister(@RequestBody UmcEnterpriseUserRegisterReqBo reqBo) {
        this.validateParams(reqBo);
        UmcEnterpriseUserRegisterRspBo rspBo = UmcRu.success(UmcEnterpriseUserRegisterRspBo.class);
        UmcEnterpriseInfoDo parentOrgDo = this.getSysOrgInfoDo(reqBo);
        Long userId = IdUtil.nextId();
        Long custId = IdUtil.nextId();
        Long orgId = IdUtil.nextId();
        UmcOrgInfo orgInfo = this.createOrg(reqBo.getUmcEnterpriseRegisterInfoBo(), reqBo.getUmcEnterpriseRegisterApplyInfoBo(), parentOrgDo, rspBo, userId, orgId, custId);
        this.createOrgApply(reqBo.getUmcEnterpriseRegisterApplyInfoBo(), orgId, userId);
        this.createUser(reqBo.getUmcUserRegisterInfoBo(), reqBo.getUmcUserRegisterApplyInfoBo(), orgInfo, rspBo, userId, custId);
        this.createUserApply(reqBo.getUmcUserRegisterApplyInfoBo());
        this.createrEnterpriseAccount(reqBo.getUmcRegisterAccountBo(), userId, orgId);
        return rspBo;
    }

    private UmcEnterpriseInfoDo getSysOrgInfoDo(UmcEnterpriseUserRegisterReqBo reqBo) {
        UmcEnterpriseInfoQryBo parentQryBo = new UmcEnterpriseInfoQryBo();
        parentQryBo.setOrgId(reqBo.getUmcEnterpriseRegisterInfoBo().getOrgInfoBo().getParentId());
        UmcEnterpriseInfoDo parentOrgDo = this.iUmcEnterpriseInfoModel.getOrgInfoDetails(parentQryBo);
        if (parentOrgDo == null || parentOrgDo.getTenantId() == null) {
            throw new BaseBusinessException("162005", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        return parentOrgDo;
    }

    private void createrEnterpriseAccount(UmcRegisterAccountBo umcRegisterAccountBo, Long userId, Long orgId) {
        if (null == umcRegisterAccountBo) {
            return;
        }
        UmcEnterpriseAccountDo addDo = UmcRu.js(umcRegisterAccountBo, UmcEnterpriseAccountDo.class);
        addDo.setAccountType("01");
        addDo.setIsShadowAccount("0");
        if (StringUtils.isEmpty((Object)umcRegisterAccountBo.getAccountId())) {
            addDo.setAccountId(IdUtil.nextId());
        }
        addDo.setOperOrgId(Convert.toStr((Object)umcRegisterAccountBo.getDeliveryCenterId()));
        addDo.setAccountStatus("1");
        addDo.setCheckStatus("1");
        addDo.setOwnerUserId(umcRegisterAccountBo.getOwnerMemId());
        addDo.setUserId(userId);
        addDo.setOrgId(orgId);
        addDo.setOwnerUserId(userId);
        this.iUmcEnterpriseAccountModel.addEnterpriseAccount(addDo);
    }

    private void createUserApply(UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo) {
        if (null == umcUserRegisterApplyInfoBo) {
            return;
        }
        UmcUserInfoApplyDo userInfoApplyDo = UmcRu.js(umcUserRegisterApplyInfoBo, UmcUserInfoApplyDo.class);
        userInfoApplyDo.setApplyId(umcUserRegisterApplyInfoBo.getApplyId());
        userInfoApplyDo.setApplyStatus(umcUserRegisterApplyInfoBo.getApplyStatus());
        userInfoApplyDo.setApplyType(umcUserRegisterApplyInfoBo.getApplyType());
        this.iUmcUserInfoApplyModel.createUserInfoApply(StrUtil.noNullStringAttr(userInfoApplyDo));
        if (ObjectUtil.isNotEmpty((Object)umcUserRegisterApplyInfoBo.getCustInfoApplyBo())) {
            UmcCustInfoApply custInfoApply = UmcRu.js(umcUserRegisterApplyInfoBo.getCustInfoApplyBo(), UmcCustInfoApply.class);
            custInfoApply.setApplyId(umcUserRegisterApplyInfoBo.getApplyId());
            this.iUmcUserInfoApplyModel.createCustInfoApply(StrUtil.noNullStringAttr(custInfoApply));
        }
    }

    private void createUser(UmcUserRegisterInfoBo umcUserRegisterInfoBo, UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo, UmcOrgInfo orgInfoBo, UmcEnterpriseUserRegisterRspBo rspBo, Long userId, Long custId) {
        if (null != umcUserRegisterInfoBo.getCustInfo()) {
            UmcCustInfo custInfo = this.buildCustInfo(umcUserRegisterInfoBo, userId, custId);
            StrUtil.noNullStringAttr(custInfo);
            this.iUmcUserInfoModel.createCustInfo(custInfo);
            umcUserRegisterApplyInfoBo.setCustInfoApplyBo(UmcRu.js(custInfo, UmcCustInfoApplyBo.class));
            rspBo.setUmcCustInfoBo(UmcRu.js(custInfo, UmcCustInfoBo.class));
        }
        UmcUserInfoDo userInfoDo = this.buildUserInfo(umcUserRegisterInfoBo, orgInfoBo, userId, custId);
        StrUtil.noNullStringAttr(userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(userInfoDo);
        rspBo.setUmcUserInfo(UmcRu.js(userInfoDo, UmcUserInfoBo.class));
        umcUserRegisterApplyInfoBo.setUserId(userId);
        umcUserRegisterApplyInfoBo.setCustId(custId);
        umcUserRegisterApplyInfoBo.setMainCustId(custId);
        umcUserRegisterApplyInfoBo.setCreateOperId(userId);
        umcUserRegisterApplyInfoBo.setOrgId(orgInfoBo.getOrgId());
        umcUserRegisterApplyInfoBo.setCompanyId(orgInfoBo.getCompanyId());
        umcUserRegisterApplyInfoBo.setOrgTreePath(orgInfoBo.getOrgTreePath());
        umcUserRegisterApplyInfoBo.setUserTagRelApplyBoList(UmcRu.jsl(userInfoDo.getUserTagRelList(), UmcUserTagRelApplyBo.class));
    }

    private UmcCustInfo buildCustInfo(UmcUserRegisterInfoBo umcUserRegisterInfoBo, Long userId, Long custId) {
        UmcCustInfo custInfo = UmcRu.js(umcUserRegisterInfoBo.getCustInfo(), UmcCustInfo.class);
        custInfo.setCustId(custId);
        custInfo.setCreateOperId(userId);
        if (!StringUtils.isEmpty((Object)umcUserRegisterInfoBo.getExtField1())) {
            custInfo.setExtField1(umcUserRegisterInfoBo.getExtField1());
        }
        if (!CollectionUtils.isEmpty((Collection)umcUserRegisterInfoBo.getUserExtMapList())) {
            ArrayList<UmcCustExtMap> custExtMapList = new ArrayList<UmcCustExtMap>();
            for (UmcUserExtMapBo custBo : umcUserRegisterInfoBo.getUserExtMapList()) {
                UmcCustExtMap custExtMap = UmcRu.js(custBo, UmcCustExtMap.class);
                custExtMap.setCustId(custId);
                custExtMap.setCreateTime(new Date());
                custExtMap.setDelFlag("0");
                custExtMapList.add(custExtMap);
            }
            custInfo.setCustExtMapList(custExtMapList);
        }
        return custInfo;
    }

    private void createOrgApply(UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo, Long orgId, Long userId) {
        if (null == umcEnterpriseRegisterApplyInfoBo) {
            return;
        }
        UmcOrgInfoApply umcEnterpriseOrgApply = UmcRu.js(umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo(), UmcOrgInfoApply.class);
        umcEnterpriseOrgApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
        if (null != umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo() && !CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo().getOrgTagRelApplyBoList())) {
            umcEnterpriseOrgApply.setOrgTagRelApplyList(UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo().getOrgTagRelApplyBoList(), UmcOrgTagRelApply.class));
            umcEnterpriseOrgApply.getOrgTagRelApplyList().forEach(umcOrgTagRelApply -> {
                umcOrgTagRelApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
                StrUtil.noNullStringAttr(umcOrgTagRelApply);
            });
        }
        umcEnterpriseOrgApply = this.iUmcEnterpriseInfoApplyModel.createOrgInfoApply(StrUtil.noNullStringAttr(umcEnterpriseOrgApply));
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseInvoiceApplyBoList())) {
            List<UmcEnterpriseInvoiceApply> umcEnterpriseInvoiceApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseInvoiceApplyBoList(), UmcEnterpriseInvoiceApply.class);
            for (UmcEnterpriseInvoiceApply enterpriseInvoiceApply : umcEnterpriseInvoiceApplyList) {
                enterpriseInvoiceApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
                enterpriseInvoiceApply.setOrgId(orgId);
                if (null == enterpriseInvoiceApply.getInvoiceId()) {
                    enterpriseInvoiceApply.setInvoiceId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseInvoiceApply);
            }
            UmcEnterpriseInfoApplyDo invoiceApply = new UmcEnterpriseInfoApplyDo();
            invoiceApply.setEnterpriseInvoiceApplyList(umcEnterpriseInvoiceApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseInvoiceApply(invoiceApply);
        }
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseBankApplyBoList())) {
            List<UmcEnterpriseBankApply> enterpriseBankApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseBankApplyBoList(), UmcEnterpriseBankApply.class);
            for (UmcEnterpriseBankApply enterpriseBankApply : enterpriseBankApplyList) {
                enterpriseBankApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
                enterpriseBankApply.setOrgId(orgId);
                if (null == enterpriseBankApply.getBankId()) {
                    enterpriseBankApply.setBankId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseBankApply);
            }
            UmcEnterpriseInfoApplyDo bankApplyList = new UmcEnterpriseInfoApplyDo();
            bankApplyList.setEnterpriseBankApplyList(enterpriseBankApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseBankApply(bankApplyList);
        }
        if (ObjectUtil.isNotEmpty((Object)umcEnterpriseRegisterApplyInfoBo.getEnterpriseContactApplyBoList())) {
            List<UmcEnterpriseContactApply> enterpriseContactApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseContactApplyBoList(), UmcEnterpriseContactApply.class);
            for (UmcEnterpriseContactApply enterpriseContactApply : enterpriseContactApplyList) {
                enterpriseContactApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
                enterpriseContactApply.setOrgId(orgId);
                if (null == enterpriseContactApply.getContactId()) {
                    enterpriseContactApply.setContactId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseContactApply);
            }
            UmcEnterpriseInfoApplyDo contactApplyList = new UmcEnterpriseInfoApplyDo();
            contactApplyList.setEnterpriseContactApplyList(enterpriseContactApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseContactApply(contactApplyList);
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterApplyInfoBo.getEnterpriseExtMapApply())) {
            List<UmcEnterpriseExtMapApply> enterpriseExtMapApplyList = UmcRu.jsl(umcEnterpriseRegisterApplyInfoBo.getEnterpriseExtMapApply(), UmcEnterpriseExtMapApply.class);
            for (UmcEnterpriseExtMapApply enterpriseExtMapApply : enterpriseExtMapApplyList) {
                if (null == enterpriseExtMapApply.getExtId()) {
                    enterpriseExtMapApply.setExtId(IdUtil.nextId());
                }
                enterpriseExtMapApply.setTenantId(umcEnterpriseOrgApply.getTenantId());
                enterpriseExtMapApply.setOrgId(orgId);
                enterpriseExtMapApply.setApplyId(umcEnterpriseRegisterApplyInfoBo.getApplyId());
                Date date = new Date();
                enterpriseExtMapApply.setCreateTime(date);
                enterpriseExtMapApply.setUpdateTime(date);
                enterpriseExtMapApply.setDelFlag("0");
                StrUtil.noNullStringAttr(enterpriseExtMapApply);
            }
            UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyExt = new UmcEnterpriseInfoApplyDo();
            umcEnterpriseInfoApplyExt.setEnterpriseExtMapApply(enterpriseExtMapApplyList);
            this.iUmcEnterpriseInfoApplyModel.createEnterpriseExtMapApply(umcEnterpriseInfoApplyExt);
        }
        UmcEnterpriseInfoApplyDo umcEnterpriseInfoApplyDo = UmcRu.js(umcEnterpriseRegisterApplyInfoBo, UmcEnterpriseInfoApplyDo.class);
        this.iUmcEnterpriseInfoApplyModel.createEnterpriseInfoApply(StrUtil.noNullStringAttr(umcEnterpriseInfoApplyDo));
    }

    private UmcOrgInfo createOrg(UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo, UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo, UmcEnterpriseInfoDo parentOrgDo, UmcEnterpriseUserRegisterRspBo rspBo, Long userId, Long orgId, Long custId) {
        UmcOrgInfo orgInfo = this.buildOrgInfo(umcEnterpriseRegisterInfoBo, parentOrgDo, userId, orgId);
        this.iUmcEnterpriseInfoModel.createOrgInfo(orgInfo);
        rspBo.setUmcOrgInfoBo(UmcRu.js((Object)orgInfo, UmcOrgInfoBo.class));
        umcEnterpriseRegisterApplyInfoBo.setOrgInfoApplyBo(UmcRu.js((Object)orgInfo, UmcOrgInfoApplyBo.class));
        umcEnterpriseRegisterApplyInfoBo.getOrgInfoApplyBo().setOrgTagRelApplyBoList(UmcRu.jsl(orgInfo.getOrgTagRelList(), UmcOrgTagRelApplyBo.class));
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                enterpriseInvoice.setOrgId(orgId);
                enterpriseInvoice.setDelFlag("0");
                enterpriseInvoice.setCreateTime(new Date());
                enterpriseInvoice.setUpdateTime(enterpriseInvoice.getCreateTime());
                if (null != enterpriseInvoice.getInvoiceId()) continue;
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
            }
            UmcEnterpriseInfoDo batchInvoice = new UmcEnterpriseInfoDo();
            batchInvoice.setEnterpriseInvoiceList(enterpriseInvoiceList);
            this.iUmcEnterpriseInfoModel.createEnterpriseInvoice((UmcEnterpriseInfoDo)((Object)StrUtil.noNullStringAttr(batchInvoice)));
            umcEnterpriseRegisterApplyInfoBo.setEnterpriseInvoiceApplyBoList(UmcRu.jsl(enterpriseInvoiceList, UmcEnterpriseInvoiceApplyBo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                enterpriseBank.setOrgId(orgId);
                enterpriseBank.setDelFlag("0");
                enterpriseBank.setCreateTime(new Date());
                enterpriseBank.setUpdateTime(enterpriseBank.getCreateTime());
                if (null == enterpriseBank.getBankId()) {
                    enterpriseBank.setBankId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseBank);
            }
            UmcEnterpriseInfoDo batchBankInfo = new UmcEnterpriseInfoDo();
            batchBankInfo.setEnterpriseBankList(enterpriseBankList);
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(batchBankInfo);
            umcEnterpriseRegisterApplyInfoBo.setEnterpriseBankApplyBoList(UmcRu.jsl(enterpriseBankList, UmcEnterpriseBankApplyBo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                enterpriseContact.setOrgId(orgId);
                enterpriseContact.setTenantId(parentOrgDo.getTenantId());
                enterpriseContact.setDelFlag("0");
                enterpriseContact.setCreateOperId(userId);
                enterpriseContact.setCustId(custId);
                enterpriseContact.setUpdateTime(enterpriseContact.getCreateTime());
                if (null == enterpriseContact.getContactId()) {
                    enterpriseContact.setContactId(IdUtil.nextId());
                }
                StrUtil.noNullStringAttr(enterpriseContact);
            }
            UmcEnterpriseInfoDo batchContact = new UmcEnterpriseInfoDo();
            batchContact.setEnterpriseContactList(enterpriseContactList);
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(batchContact);
            umcEnterpriseRegisterApplyInfoBo.setEnterpriseContactApplyBoList(UmcRu.jsl(enterpriseContactList, UmcEnterpriseContactApplyBo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseRegisterInfoBo.getEnterpriseExt())) {
            List<UmcEnterpriseExtMap> enterpriseExtMapList = UmcRu.jsl(umcEnterpriseRegisterInfoBo.getEnterpriseExt(), UmcEnterpriseExtMap.class);
            for (UmcEnterpriseExtMap enterpriseExtMap : enterpriseExtMapList) {
                if (null == enterpriseExtMap.getExtId()) {
                    enterpriseExtMap.setExtId(IdUtil.nextId());
                }
                enterpriseExtMap.setTenantId(orgInfo.getTenantId());
                enterpriseExtMap.setOrgId(orgInfo.getOrgId());
                Date date = new Date();
                enterpriseExtMap.setCreateTime(date);
                enterpriseExtMap.setUpdateTime(date);
                enterpriseExtMap.setDelFlag("0");
                StrUtil.noNullStringAttr(enterpriseExtMap);
            }
            UmcEnterpriseInfoDo extMapList = new UmcEnterpriseInfoDo();
            extMapList.setEnterpriseExt(enterpriseExtMapList);
            this.iUmcEnterpriseInfoModel.createEnterpriseExtMap(extMapList);
            umcEnterpriseRegisterApplyInfoBo.setEnterpriseExtMapApply(UmcRu.jsl(enterpriseExtMapList, UmcEnterpriseExtMapApplyBo.class));
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = UmcRu.js(umcEnterpriseRegisterInfoBo, UmcEnterpriseInfoDo.class);
        umcEnterpriseInfoDo.setOrgId(orgId);
        umcEnterpriseInfoDo.setCreateOperId(userId);
        umcEnterpriseInfoDo.setUpdateTime(umcEnterpriseInfoDo.getCreateTime());
        umcEnterpriseInfoDo.setTenantId(parentOrgDo.getTenantId());
        umcEnterpriseRegisterApplyInfoBo.setTenantId(parentOrgDo.getTenantId());
        umcEnterpriseRegisterApplyInfoBo.setOrgId(orgId);
        umcEnterpriseRegisterApplyInfoBo.setCreateOperId(userId);
        umcEnterpriseRegisterApplyInfoBo.setUpdateTime(umcEnterpriseInfoDo.getUpdateTime());
        StrUtil.noNullStringAttr(umcEnterpriseInfoDo);
        this.iUmcEnterpriseInfoModel.createEnterpriseInfo(StrUtil.noNullStringAttr(umcEnterpriseInfoDo));
        return orgInfo;
    }

    private UmcOrgInfo buildOrgInfo(UmcEnterpriseRegisterInfoBo reqBo, UmcEnterpriseInfoDo parentOrgDo, Long userId, Long orgId) {
        UmcOrgInfo umcEnterpriseOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        umcEnterpriseOrg.setOrgId(orgId);
        umcEnterpriseOrg.setParentId(parentOrgDo.getOrgId());
        umcEnterpriseOrg.setTenantId(parentOrgDo.getTenantId());
        umcEnterpriseOrg.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        umcEnterpriseOrg.setCompanyId(umcEnterpriseOrg.getOrgId());
        String treePath = parentOrgDo.getOrgTreePath() + umcEnterpriseOrg.getOrgId() + "-";
        umcEnterpriseOrg.setOrgTreePath(treePath);
        umcEnterpriseOrg.setDeep(parentOrgDo.getDeep() + 1);
        umcEnterpriseOrg.setIsVirtual("1");
        umcEnterpriseOrg.setOrgStatus("1");
        umcEnterpriseOrg.setCreateOperId(userId);
        umcEnterpriseOrg.setDelFlag("0");
        if (!CollectionUtils.isEmpty(umcEnterpriseOrg.getOrgTagRelList())) {
            for (UmcOrgTagRel orgTagRel : umcEnterpriseOrg.getOrgTagRelList()) {
                if (null == orgTagRel.getRelId()) {
                    orgTagRel.setRelId(IdUtil.nextId());
                }
                if (null == orgTagRel.getOrgId()) {
                    orgTagRel.setOrgId(umcEnterpriseOrg.getOrgId());
                }
                orgTagRel.setCreateOperId(userId);
                orgTagRel.setTagStatus("1");
            }
        }
        return umcEnterpriseOrg;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserRegisterInfoBo reqBo, UmcOrgInfo orgInfoBo, Long userId, Long custId) {
        UmcUserInfoDo userInfoDo = UmcRu.js(reqBo, UmcUserInfoDo.class);
        userInfoDo.setUserId(userId);
        userInfoDo.setCustId(custId);
        userInfoDo.setMainCustId(custId);
        userInfoDo.setCreateOperId(userId);
        userInfoDo.setOrgId(orgInfoBo.getOrgId());
        userInfoDo.setCompanyId(orgInfoBo.getCompanyId());
        userInfoDo.setOrgTreePath(orgInfoBo.getOrgTreePath());
        userInfoDo.setOrgName(orgInfoBo.getOrgName());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserTagRelList(), UmcUserTagRel.class);
            for (UmcUserTagRel userTagRel : userTagRelList) {
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setCreateTime(new Date());
                userTagRel.setUserId(userId);
                userTagRel.setCreateOperId(userId);
                userTagRel.setDelFlag("0");
            }
            userInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelList())) {
            ArrayList<SysAuthDistributeDo> sysAuthDistributeDoList = new ArrayList<SysAuthDistributeDo>();
            for (UmcUserRoleRelBo userRoleRel : reqBo.getUserRoleRelList()) {
                SysAuthDistributeDo authDistributeDo = new SysAuthDistributeDo();
                authDistributeDo.setAuthId(IdUtil.nextId());
                authDistributeDo.setUserId(userId);
                authDistributeDo.setRoleId(userRoleRel.getRoleId());
                authDistributeDo.setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER);
                authDistributeDo.setDisAgFlag(1);
                authDistributeDo.setOrgExtend(AuthConstant.ORG_EXTEND.NO);
                authDistributeDo.setCreateOperId(userId);
                authDistributeDo.setCreateTime(new Date());
                authDistributeDo.setCreateOperName(userRoleRel.getCreateOperName());
                authDistributeDo.setDelFlag("0");
                sysAuthDistributeDoList.add(authDistributeDo);
            }
            userInfoDo.setSysAuthDistributeDoList(sysAuthDistributeDoList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserExtMapList())) {
            List<UmcUserExtMap> userExtMapList = UmcRu.jsl(reqBo.getUserExtMapList(), UmcUserExtMap.class);
            for (UmcUserExtMap userExtMap : userExtMapList) {
                userExtMap.setExtId(IdUtil.nextId());
                userExtMap.setUserId(userId);
                userExtMap.setCreateTime(new Date());
                userExtMap.setDelFlag("0");
            }
            userInfoDo.setUserExtMapList(userExtMapList);
        }
        return userInfoDo;
    }

    private void validateParams(UmcEnterpriseUserRegisterReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcEnterpriseRegisterInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u4f01\u4e1a\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcEnterpriseRegisterInfoBo().getOrgInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUmcUserRegisterInfoBo()) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u7528\u6237\u6ce8\u518c\u5165\u53c2\u5bf9\u8c61\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }
}

