/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.SysAuthDistributeDo;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.sub.UmcCustExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcCustInfo;
import com.tydic.dyc.umc.model.user.sub.UmcUserExtMap;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoAddService;
import com.tydic.dyc.umc.service.user.bo.UmcUserExtMapBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoAddReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoAddRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.user.UmcUserInfoAddService"})
public class UmcUserInfoAddServiceImpl
implements UmcUserInfoAddService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"createUserInfo"})
    public UmcUserInfoAddRspBo createUserInfo(@RequestBody UmcUserInfoAddReqBo reqBo) {
        this.vaildateParam(reqBo);
        UmcUserInfoAddRspBo rspBo = UmcRu.success(UmcUserInfoAddRspBo.class);
        if (null != reqBo.getCustInfo()) {
            UmcCustInfo custInfo = this.buildCustInfo(reqBo);
            StrUtil.noNullStringAttr(custInfo);
            this.iUmcUserInfoModel.createCustInfo(custInfo);
        }
        UmcUserInfoDo userInfoDo = this.buildUserInfo(reqBo);
        StrUtil.noNullStringAttr(userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(userInfoDo);
        return rspBo;
    }

    private UmcCustInfo buildCustInfo(UmcUserInfoAddReqBo reqBo) {
        UmcCustInfo custInfo = UmcRu.js(reqBo.getCustInfo(), UmcCustInfo.class);
        custInfo.setCreateTime(new Date());
        custInfo.setUpdateTime(new Date());
        if (!StringUtils.isEmpty((Object)reqBo.getExtField1())) {
            custInfo.setExtField1(reqBo.getExtField1());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserExtMapList())) {
            ArrayList<UmcCustExtMap> custExtMapList = new ArrayList<UmcCustExtMap>();
            for (UmcUserExtMapBo custBo : reqBo.getUserExtMapList()) {
                UmcCustExtMap custExtMap = UmcRu.js(custBo, UmcCustExtMap.class);
                custExtMap.setCustId(reqBo.getCustId());
                custExtMap.setCreateTime(new Date());
                custExtMap.setDelFlag("0");
                custExtMapList.add(custExtMap);
            }
            custInfo.setCustExtMapList(custExtMapList);
        }
        return custInfo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoAddReqBo reqBo) {
        UmcUserInfoDo userInfoDo = UmcRu.js(reqBo, UmcUserInfoDo.class);
        userInfoDo.setCreateTime(new Date());
        userInfoDo.setUpdateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserTagRelList(), UmcUserTagRel.class);
            for (UmcUserTagRel userTagRel : userTagRelList) {
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setCreateTime(new Date());
                userTagRel.setUserId(reqBo.getUserId());
                userTagRel.setDelFlag("0");
            }
            userInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelList())) {
            ArrayList<SysAuthDistributeDo> sysAuthDistributeDoList = new ArrayList<SysAuthDistributeDo>();
            for (UmcUserRoleRelBo userRoleRel : reqBo.getUserRoleRelList()) {
                SysAuthDistributeDo authDistributeDo = new SysAuthDistributeDo();
                authDistributeDo.setAuthId(IdUtil.nextId());
                authDistributeDo.setUserId(reqBo.getUserId());
                authDistributeDo.setRoleId(userRoleRel.getRoleId());
                authDistributeDo.setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER);
                authDistributeDo.setDisAgFlag(1);
                authDistributeDo.setOrgExtend(AuthConstant.ORG_EXTEND.NO);
                authDistributeDo.setCreateOperId(userRoleRel.getCreateOperId());
                authDistributeDo.setCreateTime(new Date());
                authDistributeDo.setCreateOperName(userRoleRel.getCreateOperName());
                authDistributeDo.setDelFlag("0");
                sysAuthDistributeDoList.add(authDistributeDo);
            }
            userInfoDo.setSysAuthDistributeDoList(sysAuthDistributeDoList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserExtMapList())) {
            List<UmcUserExtMap> userExtMapList = UmcRu.jsl(reqBo.getUserExtMapList(), UmcUserExtMap.class);
            for (UmcUserExtMap userExtMap : userExtMapList) {
                userExtMap.setExtId(IdUtil.nextId());
                userExtMap.setUserId(reqBo.getUserId());
                userExtMap.setCreateTime(new Date());
                userExtMap.setDelFlag("0");
            }
            userInfoDo.setUserExtMapList(userExtMapList);
        }
        return userInfoDo;
    }

    private void vaildateParam(UmcUserInfoAddReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u65b0\u589e\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustInfo() == null && reqBo.getCustId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[CustInfo\u548cCustId ]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

