/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocGetMsgPushFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushResultBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocMsgResultBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycUocGetMsgPushFunctionImpl
implements DycUocGetMsgPushFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocGetMsgPushFunctionImpl.class);
    private static final String BUSINESS_ORDE = "BUSINESS_ORDER";
    @Autowired
    private Environment env;

    @Override
    public DycUocGetMsgPushFuncRspBO getMsg(DycUocGetMsgPushFuncReqBO reqBO) {
        String reqStr = this.initReqStr(reqBO);
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        JSONObject resultJson = new JSONObject();
        JSONObject reqJsonObject = JSONObject.parseObject((String)reqStr);
        resultJson.putAll((Map)reqJsonObject);
        String httpRspStr = null;
        try {
            httpRspStr = DycEsbUtil.doPostReuest(DycPropertiesUtil.getProperty("ESB_QRY_MSG_URL"), resultJson.toJSONString(), hsn);
            log.info("\u6d88\u606f\u67e5\u8be2httpRspStr: {}", (Object)httpRspStr);
        }
        catch (ZTBusinessException e) {
            log.error("\u83b7\u53d6\u63a8\u9001\u6d88\u606f\u63a5\u53e3\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        DycUocGetMsgPushFuncRspBO resolveRsp = this.resolveRsp(httpRspStr, reqBO.getIsAnalysis());
        log.debug("\u63a8\u9001\u6d88\u606f\u51fa\u53c2 \u5f00\u59cb\u6253\u5370");
        List<DycUocGetMsgPushResultBO> resultList = resolveRsp.getResult();
        return resolveRsp;
    }

    private String initReqStr(DycUocGetMsgPushFuncReqBO busiQryMsgReqBO) {
        return "{\"type\":" + busiQryMsgReqBO.getType() + "}";
    }

    private DycUocGetMsgPushFuncRspBO resolveRsp(String returnString, boolean isAnalysis) {
        DycUocGetMsgPushFuncRspBO busiQryMsgRspBO = new DycUocGetMsgPushFuncRspBO();
        ArrayList<DycUocGetMsgPushResultBO> list = new ArrayList<DycUocGetMsgPushResultBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(rspJsonObject.getBoolean("success"));
            busiQryMsgRspBO.setResultCode(Integer.parseInt((String)rspJsonObject.get((Object)"resultCode")));
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (Object singleObject : object) {
                    JSONObject obj = (JSONObject)singleObject;
                    if (!isAnalysis) {
                        String id = obj.getString("id");
                        Long type = obj.getLong("type");
                        Date time = obj.getDate("time");
                        String result = obj.getString("result");
                        DycUocGetMsgPushResultBO temp = new DycUocGetMsgPushResultBO();
                        temp.setId(id);
                        temp.setTime(time);
                        temp.setType(type);
                        temp.setResultString(result);
                        temp.setResult(new DycUocMsgResultBO());
                        list.add(temp);
                        continue;
                    }
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    DycUocGetMsgPushResultBO jsonStringToJavaBean = (DycUocGetMsgPushResultBO)JSON.parseObject((String)jsonStr, DycUocGetMsgPushResultBO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return busiQryMsgRspBO;
    }
}

