/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.api.DycGeneralTabsCountQueryFunction;
import com.tydic.dyc.atom.common.bo.DycCommonTabsCountBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycGeneralTabsCountQueryFunctionImpl
implements DycGeneralTabsCountQueryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycGeneralTabsCountQueryFunctionImpl.class);
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";
    public static final String RECORDS_TOTAL = "recordsTotal";
    @Value(value="${qry.url}")
    private String generalQueryUrl;

    @Override
    public DycGeneralTabsCountQueryFuncRspBO getTabsCount(DycGeneralTabsCountQueryFuncReqBO reqBO) {
        DycGeneralTabsCountQueryFuncRspBO rspBO = new DycGeneralTabsCountQueryFuncRspBO();
        this.validateArg(reqBO);
        Map<Integer, Map<String, Object>> tabsCountMap = this.getTabsCountMap(reqBO);
        this.setTabCount(rspBO, reqBO, tabsCountMap);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validateArg(DycGeneralTabsCountQueryFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u5217\u8868\u6570\u91cf\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getDycGeneralTabsCountQueryBOS())) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u5217\u8868\u6570\u91cf\u5165\u53c2\u5bf9\u8c61[dycGeneralTabsCountQueryBOS]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycGeneralTabsCountQueryBO dycGeneralTabsCountQueryBO : reqBo.getDycGeneralTabsCountQueryBOS()) {
            if (ObjectUtil.isEmpty((Object)dycGeneralTabsCountQueryBO.getTabId())) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u5217\u8868\u6570\u91cf\u5165\u53c2\u5bf9\u8c61[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)dycGeneralTabsCountQueryBO.getTabName())) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u5217\u8868\u6570\u91cf\u5165\u53c2\u5bf9\u8c61[tabName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)dycGeneralTabsCountQueryBO.getParamJsonStr())) continue;
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u5217\u8868\u6570\u91cf\u5165\u53c2\u5bf9\u8c61[paramJsonStr]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<Integer, Map<String, Object>> getTabsCountMap(DycGeneralTabsCountQueryFuncReqBO reqBO) {
        HashMap<Integer, Map<String, Object>> tabCountMap = new HashMap<Integer, Map<String, Object>>();
        for (DycGeneralTabsCountQueryBO dycGeneralTabsCountQueryBO : reqBO.getDycGeneralTabsCountQueryBOS()) {
            Date now = new Date();
            DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
            dycGeneralQueryFuncReqBO.setQueryCountFlag(true);
            JSONObject baseReqJsonObj = JSON.parseObject((String)dycGeneralTabsCountQueryBO.getParamJsonStr());
            log.info("\u67e5\u8be2\u6570\u91cf\u5165\u53c2:{}", (Object)baseReqJsonObj.toJSONString());
            dycGeneralQueryFuncReqBO.setReqParams(baseReqJsonObj.toJSONString());
            log.info("\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dycGeneralQueryFuncReqBO));
            String rspJsonStr = HttpUtil.post((String)this.generalQueryUrl, (String)JSON.toJSONString((Object)dycGeneralQueryFuncReqBO), (int)4000);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)RECORDS_TOTAL)) ? jsonObject.get((Object)RECORDS_TOTAL) : Integer.valueOf(0));
            }
            map.put(TAB_NAME, null != dycGeneralTabsCountQueryBO.getTabName() ? dycGeneralTabsCountQueryBO.getTabName() : "");
            tabCountMap.put(dycGeneralTabsCountQueryBO.getTabId(), map);
            Date now2 = new Date();
            log.info("\u5faa\u73af\u67e5\u8be2\u6570\u91cf\u65f6\u95f4\u5f00\u59cb:{} \u7ed3\u675f:{} \u8017\u65f6:{}ms", new Object[]{DateUtils.dateToStr((Date)now, (String)"yyyy-MM-dd HH:mm:ss SSS"), DateUtils.dateToStr((Date)now2, (String)"yyyy-MM-dd HH:mm:ss SSS"), now2.getTime() - now.getTime()});
        }
        return tabCountMap;
    }

    private void setTabCount(DycGeneralTabsCountQueryFuncRspBO rspBO, DycGeneralTabsCountQueryFuncReqBO reqBO, Map<Integer, Map<String, Object>> tabsCountMap) {
        ArrayList<DycCommonTabsCountBO> afTabCountList = new ArrayList<DycCommonTabsCountBO>();
        for (DycGeneralTabsCountQueryBO each : reqBO.getDycGeneralTabsCountQueryBOS()) {
            DycCommonTabsCountBO tabCountsBO = new DycCommonTabsCountBO();
            tabCountsBO.setTabId(each.getTabId());
            if (ObjectUtil.isNotEmpty(tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                tabCountsBO.setTabCount((Integer)tabsCountMap.get(each.getTabId()).get(TAB_COUNT));
                tabCountsBO.setTabName(tabsCountMap.get(each.getTabId()).get(TAB_NAME).toString());
                if (tabCountsBO.getTabName().startsWith("\u5168\u90e8")) {
                    tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                } else {
                    tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                }
            }
            afTabCountList.add(tabCountsBO);
        }
        rspBO.setTabCountList(afTabCountList);
    }
}

