/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.DycFuncRspConstants;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreAfterOrderApplyFunction;
import com.tydic.dyc.atom.estore.api.DycUocJdAddressQryFunction;
import com.tydic.dyc.atom.estore.bo.DycComUocAddressFuncBO;
import com.tydic.dyc.atom.estore.bo.DycComUocAfterOrderItemFuncBO;
import com.tydic.dyc.atom.estore.bo.DycComUocAttachFuncBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderApplyFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderApplyFuncRspBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsApplyInfoItem;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsCustomerInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsPickupWareInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsReturnWareInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterOrderEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.CustomerEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.DetailEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.JDAfterOrderEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.PickwareEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.ReturnwareEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.WareDescInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.WareDetailInfo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreAfterOrderApplyFunctionImpl
implements DycUocEstoreAfterOrderApplyFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreAfterOrderApplyFunctionImpl.class);
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocQryShipOrderDetailsService uocQryShipOrderDetailsService;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Autowired
    private DycUocJdAddressQryFunction dycUocJdAddressQryFunction;

    @Override
    public DycUocEstoreAfterOrderApplyFuncRspBO createEstoreAfterOrder(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        this.validateArg(reqBo);
        DycUocEstoreAfterOrderApplyFuncRspBO rsp = new DycUocEstoreAfterOrderApplyFuncRspBO();
        UocQryShipOrderDetailsRspBo shipOrderDetails = this.qryShipOrderDetails(reqBo);
        UocGetSaleOrderDetailServiceRspBo saleOrderDetails = this.qrySaleOrderDetails(reqBo);
        AfterOrderEntity afterOrderEntity = this.buildAfterOrderEntity(shipOrderDetails, saleOrderDetails, reqBo);
        String hsn = DycPropertiesUtil.getProperty("SUPPLIER_ID_" + saleOrderDetails.getSupId());
        if (saleOrderDetails.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JD_ID")) || saleOrderDetails.getSupId().equals(DycPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID"))) {
            JDAfterOrderEntity jdAfterOrderEntity = this.buildJDAfterOrderEntity(shipOrderDetails, saleOrderDetails, reqBo);
            JSONObject jdParam = new JSONObject();
            jdParam.put("param", (Object)jdAfterOrderEntity);
            jdParam.put("orgId", (Object)saleOrderDetails.getPurOrgId());
            if (UocConstant.ModelSettle.MY.equals(saleOrderDetails.getModelSettle())) {
                jdParam.put("orgId", (Object)saleOrderDetails.getUocGetSaleOrderDetailServiceRspStakeholderBo().getProId());
            } else {
                jdParam.put("orgId", (Object)saleOrderDetails.getUocGetSaleOrderDetailServiceRspStakeholderBo().getPurOrgId());
            }
            log.info("\u4eac\u4e1c\u552e\u540e\u53d1\u8d77httpReqStr: {}", (Object)JSONObject.toJSONString((Object)jdParam));
            try {
                Date callTime = new Date();
                String httpRspStr = DycEsbUtil.doPostReuest(reqBo.getRequestUrl(), JSONObject.toJSONString((Object)jdParam), hsn);
                Date retTime = new Date();
                this.intsertInterLog(reqBo.getOrderId(), reqBo.getShipOrderId(), callTime, retTime, hsn, reqBo.getRequestUrl(), JSONObject.toJSONString((Object)jdParam), httpRspStr);
                log.info("\u4eac\u4e1c\u552e\u540e\u53d1\u8d77httpRspStr: {}", (Object)httpRspStr);
                JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
                if (!rspJsonObject.getBoolean("success").booleanValue()) {
                    throw new ZTBusinessException("\u8c03\u7528\u4eac\u4e1c\u7535\u5546\u552e\u540e\u5f02\u5e38");
                }
                rsp.setServiceId(jdAfterOrderEntity.getThirdApplyId());
                rsp.setThirdApplyId(jdAfterOrderEntity.getThirdApplyId());
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        try {
            log.info("\u8c03\u7528\u7535\u5546\u552e\u540e\u53d1\u8d77\u5165\u53c2: {}", (Object)JSONObject.toJSONString((Object)afterOrderEntity));
            Date callTime = new Date();
            String httpRspStr = DycEsbUtil.doPostReuest(reqBo.getRequestUrl(), JSONObject.toJSONString((Object)afterOrderEntity), hsn);
            Date retTime = new Date();
            this.intsertInterLog(reqBo.getOrderId(), reqBo.getShipOrderId(), callTime, retTime, hsn, reqBo.getRequestUrl(), JSONObject.toJSONString((Object)afterOrderEntity), httpRspStr);
            log.info("\u8c03\u7528\u7535\u5546\u552e\u540e\u53d1\u8d77\u51fa\u53c2: {}", (Object)httpRspStr);
            this.resolveRsp(httpRspStr, rsp);
        }
        catch (ZTBusinessException e) {
            throw new ZTBusinessException(e.getMessage());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private UocGetSaleOrderDetailServiceRspBo qrySaleOrderDetails(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(reqBo.getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo uocGetSaleOrderDetailServiceRspBo = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        if ("0000".equals(uocGetSaleOrderDetailServiceRspBo.getRespCode())) {
            return uocGetSaleOrderDetailServiceRspBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u5931\u8d25\uff1a" + uocGetSaleOrderDetailServiceRspBo.getRespDesc());
    }

    private JDAfterOrderEntity buildJDAfterOrderEntity(UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo, UocGetSaleOrderDetailServiceRspBo orderAllDetail, DycUocEstoreAfterOrderApplyFuncReqBO reqBO) {
        List<DycComUocAfterOrderItemFuncBO> shipItemList;
        JDAfterOrderEntity afterOrderEntity = new JDAfterOrderEntity();
        List saleOrderDetailServiceRspItemBoList = orderAllDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<String, UocGetSaleOrderDetailServiceRspItemBo> saleItemMaps = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSkuId, o -> o));
        String orderNoExt = orderAllDetail.getSaleOrderNoExt();
        afterOrderEntity.setOrderId(orderNoExt);
        afterOrderEntity.setThirdApplyId(String.valueOf(System.currentTimeMillis()));
        List shipOrderItemBoList = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderItemBoList();
        Map<Long, UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(UocQryShipOrderDetailsRspDetailItemBo::getShipOrderItemId, o -> o));
        if (ObjectUtil.isNotEmpty((Object)((Object)reqBO))) {
            AfsReturnWareInfo returnWareInfo;
            DycComUocAddressFuncBO returnAddress;
            AfsCustomerInfo customerInfo = new AfsCustomerInfo();
            customerInfo.setCustomerName(reqBO.getName());
            customerInfo.setCustomerContactName(ObjectUtil.isNotEmpty((Object)reqBO.getTakeAddress()) ? reqBO.getTakeAddress().getContactName() : reqBO.getReturnAddress().getContactName());
            customerInfo.setCustomerMobilePhone(ObjectUtil.isNotEmpty((Object)reqBO.getTakeAddress()) ? reqBO.getTakeAddress().getContactMobile() : reqBO.getReturnAddress().getContactMobile());
            afterOrderEntity.setCustomerInfo(customerInfo);
            DycComUocAddressFuncBO takeAddress = reqBO.getTakeAddress();
            if (ObjectUtil.isNotEmpty((Object)takeAddress)) {
                this.qryJdAddressInfo(orderAllDetail.getSupId(), takeAddress);
                AfsPickupWareInfo pickwareInfo = new AfsPickupWareInfo();
                pickwareInfo.setPickwareType(reqBO.getPickwareType());
                pickwareInfo.setPickWareProvince(ObjectUtil.isEmpty((Object)takeAddress) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
                pickwareInfo.setPickWareCity(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                pickwareInfo.setPickWareCounty(ObjectUtil.isEmpty((Object)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
                pickwareInfo.setPickWareVillage(ObjectUtil.isEmpty((Object)takeAddress.getContactTownId()) ? 0 : Integer.valueOf(takeAddress.getContactTownId()));
                pickwareInfo.setPickWareAddress(ObjectUtil.isEmpty((Object)takeAddress.getContactAddress()) ? null : takeAddress.getContactAddress());
                afterOrderEntity.setPickwareInfo(pickwareInfo);
            }
            if (ObjectUtil.isNotEmpty((Object)(returnAddress = reqBO.getReturnAddress())) && null != returnAddress.getContactProvinceId() && null != returnAddress.getContactCityId()) {
                this.qryJdAddressInfo(orderAllDetail.getSupId(), returnAddress);
                returnWareInfo = new AfsReturnWareInfo();
                returnWareInfo.setReturnWareType(10);
                returnWareInfo.setReturnWareProvince(ObjectUtil.isEmpty((Object)returnAddress.getContactProvinceId()) ? null : Integer.valueOf(returnAddress.getContactProvinceId()));
                returnWareInfo.setReturnWareCity(ObjectUtil.isEmpty((Object)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
                returnWareInfo.setReturnWareCountry(ObjectUtil.isEmpty((Object)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
                returnWareInfo.setReturnWareVillage(ObjectUtil.isEmpty((Object)returnAddress.getContactTownId()) ? 0 : Integer.parseInt(returnAddress.getContactTownId()));
                returnWareInfo.setReturnWareAddress(ObjectUtil.isEmpty((Object)returnAddress.getContactAddress()) ? null : returnAddress.getContactAddress());
                afterOrderEntity.setReturnWareInfo(returnWareInfo);
            }
            if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN.equals(reqBO.getServType())) {
                returnWareInfo = new AfsReturnWareInfo();
                returnWareInfo.setReturnWareType(10);
                returnWareInfo.setReturnWareProvince(ObjectUtil.isEmpty((Object)takeAddress.getContactProvinceId()) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
                returnWareInfo.setReturnWareCity(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                returnWareInfo.setReturnWareCountry(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                returnWareInfo.setReturnWareVillage(ObjectUtil.isEmpty((Object)takeAddress.getContactTownId()) ? 0 : Integer.parseInt(takeAddress.getContactTownId()));
                returnWareInfo.setReturnWareAddress(ObjectUtil.isEmpty((Object)takeAddress.getContactAddress()) ? null : takeAddress.getContactAddress());
                afterOrderEntity.setReturnWareInfo(returnWareInfo);
            }
        }
        if (CollectionUtil.isNotEmpty(shipItemList = reqBO.getShipItemList())) {
            ArrayList<AfsApplyInfoItem> afsApplyInfoItemList = new ArrayList<AfsApplyInfoItem>();
            for (DycComUocAfterOrderItemFuncBO dycComUocAfterOrderItemFuncBO : shipItemList) {
                UocQryShipOrderDetailsRspDetailItemBo shipItem = shipOrderItemMaps.get(dycComUocAfterOrderItemFuncBO.getShipOrderItemId());
                String skuExtSkuId = saleItemMaps.get(shipItem.getSkuId()).getSkuExtSkuId();
                AfsApplyInfoItem afsApplyInfoItem = new AfsApplyInfoItem();
                afsApplyInfoItem.setCustomerExpect(reqBO.getServType());
                WareDescInfo wareDescInfo = new WareDescInfo();
                List<DycComUocAttachFuncBO> orderAccessoryBoList = reqBO.getOrderAccessoryBoList();
                if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
                    wareDescInfo.setQuestionPic(orderAccessoryBoList.stream().map(x -> x.getAccessoryUrl()).collect(Collectors.joining(",")));
                }
                wareDescInfo.setQuestionDesc(reqBO.getQuestionDesc());
                afsApplyInfoItem.setWareDescInfo(wareDescInfo);
                WareDetailInfo wareDetailInfo = new WareDetailInfo();
                wareDetailInfo.setWareId(Long.valueOf(skuExtSkuId));
                wareDetailInfo.setMainWareId(Long.valueOf(skuExtSkuId));
                wareDetailInfo.setWareName(saleItemMaps.get(shipItem.getSkuId()).getSkuName());
                wareDetailInfo.setWareNum(Integer.valueOf(dycComUocAfterOrderItemFuncBO.getReturnCount().toPlainString()));
                wareDetailInfo.setWareType(10);
                afsApplyInfoItem.setWareDetailInfo(wareDetailInfo);
                afsApplyInfoItemList.add(afsApplyInfoItem);
            }
            afterOrderEntity.setAfsApplyInfoItemList(afsApplyInfoItemList);
        }
        return afterOrderEntity;
    }

    private void qryJdAddressInfo(String supplierId, DycComUocAddressFuncBO oldAddress) {
        String address = oldAddress.getContactProvinceName() + oldAddress.getContactCityName() + oldAddress.getContactCountyName() + oldAddress.getContactTown() + oldAddress.getContactAddress();
        DycUocJdAddressQryFunctionReqBO dycUocJdAddressQryFunctionReqBO = new DycUocJdAddressQryFunctionReqBO();
        dycUocJdAddressQryFunctionReqBO.setAddress(address);
        dycUocJdAddressQryFunctionReqBO.setSupplierId(supplierId);
        dycUocJdAddressQryFunctionReqBO.setIsCheckArea(true);
        dycUocJdAddressQryFunctionReqBO.setContactProvinceId(oldAddress.getContactProvinceId());
        dycUocJdAddressQryFunctionReqBO.setContactCityId(oldAddress.getContactCityId());
        dycUocJdAddressQryFunctionReqBO.setContactCountyId(oldAddress.getContactCountyId());
        dycUocJdAddressQryFunctionReqBO.setContactTownId(oldAddress.getContactTownId());
        DycUocJdAddressQryFunctionRspBO dycUocJdAddressQryFunctionRspBO = this.dycUocJdAddressQryFunction.qryAddressInfo(dycUocJdAddressQryFunctionReqBO);
        if (!"0000".equals(dycUocJdAddressQryFunctionRspBO.getRespCode())) {
            throw new ZTBusinessException(dycUocJdAddressQryFunctionRspBO.getRespDesc());
        }
        oldAddress.setContactCountryId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountryId());
        oldAddress.setContactProvinceId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactProvinceId());
        oldAddress.setContactCityId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCityId());
        oldAddress.setContactCountyId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountyId());
        oldAddress.setContactTownId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactTownId());
    }

    private UocQryShipOrderDetailsRspBo qryShipOrderDetails(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        UocQryShipOrderDetailsReqBo uocQryShipOrderDetailsReqBo = new UocQryShipOrderDetailsReqBo();
        uocQryShipOrderDetailsReqBo.setOrderId(reqBo.getOrderId());
        uocQryShipOrderDetailsReqBo.setShipOrderId(reqBo.getShipOrderId());
        UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo = this.uocQryShipOrderDetailsService.qryShipOrderDetails(uocQryShipOrderDetailsReqBo);
        if ("0000".equals(uocQryShipOrderDetailsRspBo.getRespCode())) {
            return uocQryShipOrderDetailsRspBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u5931\u8d25\uff1a" + uocQryShipOrderDetailsRspBo.getRespDesc());
    }

    private void resolveRsp(String httpRspStr, DycUocEstoreAfterOrderApplyFuncRspBO rsp) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            String defineAfsOrderIdName;
            JSONObject jsonObject;
            if (rspJsonObject.get((Object)"result") != null && (jsonObject = (JSONObject)rspJsonObject.get((Object)"result")).get((Object)(defineAfsOrderIdName = "serviceId")) != null) {
                rsp.setServiceId(String.valueOf(jsonObject.get((Object)"serviceId")));
            }
        } else {
            throw new ZTBusinessException("\u552e\u540e\u8c03\u7528\u7535\u5546\u5f02\u5e38" + JSONObject.parseObject((String)httpRspStr).getString("resultMessage"));
        }
    }

    private AfterOrderEntity buildAfterOrderEntity(UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo, UocGetSaleOrderDetailServiceRspBo orderAllDetail, DycUocEstoreAfterOrderApplyFuncReqBO reqBO) {
        AfterOrderEntity afterOrderEntity = new AfterOrderEntity();
        String orderNoExt = orderAllDetail.getSaleOrderNoExt();
        List saleOrderDetailServiceRspItemBoList = orderAllDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<String, UocGetSaleOrderDetailServiceRspItemBo> saleItemMaps = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSkuId, o -> o));
        afterOrderEntity.setOrderId(orderNoExt);
        String shipOrderNoExt = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderNoExt();
        List shipOrderItemBoList = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderItemBoList();
        Map<Long, UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(UocQryShipOrderDetailsRspDetailItemBo::getShipOrderItemId, o -> o));
        afterOrderEntity.setPackageId(shipOrderNoExt);
        CustomerEntity customerEntity = new CustomerEntity();
        PickwareEntity pickwareEntity = new PickwareEntity();
        ReturnwareEntity returnwareEntity = new ReturnwareEntity();
        if (ObjectUtil.isNotEmpty((Object)((Object)reqBO))) {
            afterOrderEntity.setServiceType(reqBO.getServType());
            afterOrderEntity.setQuestionDesc(reqBO.getQuestionDesc());
            List<DycComUocAttachFuncBO> orderAccessoryBoList = reqBO.getOrderAccessoryBoList();
            if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
                afterOrderEntity.setQuestionPic(orderAccessoryBoList.stream().map(x -> x.getAccessoryUrl()).collect(Collectors.joining(",")));
            }
            customerEntity.setCustomerContactName(orderAllDetail.getReceiverAddressBo().getContactName());
            customerEntity.setCustomerMobilePhone(orderAllDetail.getReceiverAddressBo().getContactMobile());
            pickwareEntity.setPickwareType(reqBO.getPickwareType());
            DycComUocAddressFuncBO takeAddress = reqBO.getTakeAddress();
            DycComUocAddressFuncBO returnAddress = reqBO.getReturnAddress();
            if (ObjectUtil.isNotEmpty((Object)takeAddress)) {
                pickwareEntity.setPickwareProvince(ObjectUtil.isEmpty((Object)takeAddress.getContactProvinceId()) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
                pickwareEntity.setPickwareCity(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                pickwareEntity.setPickwareCounty(ObjectUtil.isEmpty((Object)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
                pickwareEntity.setPickwareVillage(ObjectUtil.isEmpty((Object)takeAddress.getContactTownId()) ? null : Integer.valueOf(takeAddress.getContactTownId()));
                pickwareEntity.setPickwareAddress(takeAddress.getContactAddress());
                customerEntity.setCustomerContactName(ObjectUtil.isEmpty((Object)takeAddress.getContactName()) ? orderAllDetail.getReceiverAddressBo().getContactName() : takeAddress.getContactName());
                customerEntity.setCustomerMobilePhone(ObjectUtil.isEmpty((Object)takeAddress.getContactMobile()) ? orderAllDetail.getReceiverAddressBo().getContactMobile() : takeAddress.getContactMobile());
            }
            if (ObjectUtil.isNotEmpty((Object)returnAddress)) {
                returnwareEntity.setReturnwareProvince(ObjectUtil.isEmpty((Object)returnAddress.getContactProvinceId()) ? null : Integer.valueOf(returnAddress.getContactProvinceId()));
                returnwareEntity.setReturnwareCity(ObjectUtil.isEmpty((Object)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
                returnwareEntity.setReturnwareCounty(ObjectUtil.isEmpty((Object)returnAddress.getContactCountyId()) ? null : Integer.valueOf(returnAddress.getContactCountyId()));
                returnwareEntity.setReturnwareVillage(ObjectUtil.isEmpty((Object)returnAddress.getContactTownId()) ? null : Integer.valueOf(returnAddress.getContactTownId()));
                returnwareEntity.setReturnwareAddress(returnAddress.getContactAddress());
            }
        }
        afterOrderEntity.setCustomer(customerEntity);
        afterOrderEntity.setPickware(pickwareEntity);
        afterOrderEntity.setReturnware(returnwareEntity);
        ArrayList<DetailEntity> detailEntities = new ArrayList<DetailEntity>();
        List<DycComUocAfterOrderItemFuncBO> shipItemList = reqBO.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            for (DycComUocAfterOrderItemFuncBO dycComUocAfterOrderItemFuncBO : shipItemList) {
                UocQryShipOrderDetailsRspDetailItemBo shipItem = shipOrderItemMaps.get(dycComUocAfterOrderItemFuncBO.getShipOrderItemId());
                String skuExtSkuId = saleItemMaps.get(shipItem.getSkuId()).getSkuExtSkuId();
                DetailEntity detailEntity = new DetailEntity();
                detailEntity.setSkuId(skuExtSkuId);
                detailEntity.setSkuNum(dycComUocAfterOrderItemFuncBO.getReturnCount().toPlainString());
                detailEntities.add(detailEntity);
            }
        }
        afterOrderEntity.setDetail(detailEntities);
        return afterOrderEntity;
    }

    private void validateArg(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355shipOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getTakeAddress()) && ObjectUtil.isNotEmpty((Object)reqBo.getTakeAddress().getContactMobile()) && !Pattern.matches("^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$", reqBo.getTakeAddress().getContactMobile())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
        }
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(2));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

