/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallSalesVolumeAbilityService;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductSkuNumFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuStockInfoRecordsChangeType;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommSkuStockDeductService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocDeductSkuNumFunctionImpl
implements DycUocDeductSkuNumFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocDeductSkuNumFunctionImpl.class);
    @Autowired
    private UccMallSalesVolumeAbilityService uccMallSalesVolumeAbilityService;
    @Autowired
    private DycProCommSkuStockDeductService dycProCommSkuStockDeductService;

    @Override
    public DycUocDeductSkuNumFuncRspBO dealDeductSkuNum(DycUocDeductSkuNumFuncReqBO reqBO) {
        this.verifyParam(reqBO);
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        for (DycUocDeductSkuNumFuncBO bo : reqBO.getSkuDetailBos()) {
            resultMap.put(bo.getSkuId(), resultMap.getOrDefault(bo.getSkuId(), BigDecimal.ZERO).add(bo.getPurchaseCount()));
        }
        DycProCommSkuStockDeductReqBO dycProCommSkuStockDeductReqBO = new DycProCommSkuStockDeductReqBO();
        ArrayList<DycProCommSkuStockDeductBO> deductBOList = new ArrayList<DycProCommSkuStockDeductBO>();
        for (Map.Entry entry : resultMap.entrySet()) {
            DycProCommSkuStockDeductBO dycProCommSkuStockDeductBO = new DycProCommSkuStockDeductBO();
            dycProCommSkuStockDeductBO.setSkuId((Long)entry.getKey());
            dycProCommSkuStockDeductBO.setDeductAmount((BigDecimal)entry.getValue());
            deductBOList.add(dycProCommSkuStockDeductBO);
        }
        dycProCommSkuStockDeductReqBO.setDeductBOList(deductBOList);
        Integer changeType = Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_REDUCE.getCode());
        if ("1".equals(reqBO.getOperType())) {
            changeType = Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_BACK.getCode());
        }
        dycProCommSkuStockDeductReqBO.setChangeType(changeType);
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u5165\u53c2" + JSON.toJSONString((Object)dycProCommSkuStockDeductReqBO));
        DycProCommSkuStockDeductRspBO dycProCommSkuStockDeductRspBO = this.dycProCommSkuStockDeductService.dealSkuStockDeduct(dycProCommSkuStockDeductReqBO);
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u51fa\u53c2" + JSON.toJSONString((Object)dycProCommSkuStockDeductRspBO));
        if ("0000".equals(dycProCommSkuStockDeductRspBO.getRespCode())) {
            DycUocDeductSkuNumFuncRspBO rspBO = new DycUocDeductSkuNumFuncRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new BaseBusinessException(dycProCommSkuStockDeductRspBO.getRespCode(), "\u8c03\u7528\u5546\u54c1\u5e93\u5b58\u6263\u51cfAPI\u5931\u8d25\uff1a" + dycProCommSkuStockDeductRspBO.getRespDesc());
    }

    private void verifyParam(DycUocDeductSkuNumFuncReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getSkuDetailBos())) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperType())) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

