/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.MaterialMatchCheckAbilityService;
import com.tydic.commodity.common.ability.bo.MaterialMatchCheckAbilityReqBO;
import com.tydic.commodity.common.ability.bo.MaterialMatchCheckAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractImportNoSourceAgreeContractItemService;
import com.tydic.dyc.contract.bo.DycContractImportNoSourceAgreeContractItemReqBO;
import com.tydic.dyc.contract.bo.DycContractImportNoSourceAgreeContractItemRspBO;
import com.tydic.dyc.contract.bo.DycContractNoSourceAgreeContractItemInfoBO;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.contract.api.DycContractImportNoSourceAgreeContractItemService"})
public class DycContractImportNoSourceAgreeContractItemServiceImpl
implements DycContractImportNoSourceAgreeContractItemService {
    private static final Logger log = LoggerFactory.getLogger(DycContractImportNoSourceAgreeContractItemServiceImpl.class);
    @Autowired
    private MaterialMatchCheckAbilityService materialMatchCheckAbilityService;
    private static final String XLSX = "xlsx";
    private static final String XLS = "xls";

    @Override
    @PostMapping(value={"importNoSourceAgreeContractItem"})
    public DycContractImportNoSourceAgreeContractItemRspBO importNoSourceAgreeContractItem(@RequestBody DycContractImportNoSourceAgreeContractItemReqBO reqBO) {
        XSSFWorkbook workbook;
        ArrayList<DycContractNoSourceAgreeContractItemInfoBO> rows;
        block19: {
            this.validate(reqBO);
            rows = new ArrayList<DycContractNoSourceAgreeContractItemInfoBO>();
            workbook = null;
            InputStream inputStream = null;
            String fileUrl = reqBO.getFileUrl();
            URL url = null;
            try {
                url = new URL(fileUrl);
            }
            catch (MalformedURLException e) {
                throw new ZTBusinessException("\u4ece\u7f51\u7edc\u8bfb\u53d6excel\u51fa\u9519");
            }
            try {
                inputStream = url.openStream();
                if (fileUrl.toLowerCase().endsWith(XLSX)) {
                    workbook = new XSSFWorkbook(inputStream);
                    break block19;
                }
                if (fileUrl.toLowerCase().endsWith(XLS)) {
                    workbook = new HSSFWorkbook(inputStream);
                    break block19;
                }
                throw new ZTBusinessException("\u4e0d\u662f\u88ab\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u5931\u8d25");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ZTBusinessException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25");
                }
            }
        }
        Sheet sheet = workbook.getSheetAt(0);
        int rowCount = sheet.getPhysicalNumberOfRows();
        int cellCount = 0;
        log.debug("\u5f53\u524dexcel\u7684\u884c\u6570\uff1a" + rowCount);
        for (int i = 0; i < rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (row != null && i == 0) {
                cellCount = row.getPhysicalNumberOfCells();
                log.debug("\u5f53\u524dexcel\u7684\u5217\u6570\uff1a" + cellCount);
            }
            if (row == null || i == 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < cellCount; ++j) {
                if (row.getCell(j) != null) {
                    list.add(row.getCell(j).toString());
                    continue;
                }
                list.add("");
            }
            DycContractNoSourceAgreeContractItemInfoBO infoBO = new DycContractNoSourceAgreeContractItemInfoBO();
            infoBO.setMaterialType((String)list.get(1));
            infoBO.setMaterialCode((String)list.get(2));
            infoBO.setMaterialName((String)list.get(3));
            infoBO.setSpec((String)list.get(4));
            infoBO.setModel((String)list.get(5));
            infoBO.setBrand((String)list.get(6));
            infoBO.setManufacturer((String)list.get(7));
            infoBO.setSupplyCycle(this.stringToInteger((String)list.get(8)));
            infoBO.setUnitName((String)list.get(9));
            infoBO.setBuyCount(this.stringToBig((String)list.get(10)));
            infoBO.setUnitPriceMoney(this.stringToBig((String)list.get(11)));
            infoBO.setTotalAmountMoney(this.stringToBig((String)list.get(12)));
            rows.add(infoBO);
        }
        if (!CollectionUtils.isEmpty(rows)) {
            List materialBOList = rows.stream().map(each -> {
                UccEMdmMaterialBO bo = new UccEMdmMaterialBO();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                return bo;
            }).collect(Collectors.toList());
            MaterialMatchCheckAbilityReqBO abilityReqBO = new MaterialMatchCheckAbilityReqBO();
            abilityReqBO.setIsBatch(Boolean.valueOf(true));
            abilityReqBO.setMaterialBOList(materialBOList);
            MaterialMatchCheckAbilityRspBO abilityRspBO = this.materialMatchCheckAbilityService.checkMaterialIsMatch(abilityReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new ZTBusinessException(abilityRspBO.getRespDesc());
            }
        }
        DycContractImportNoSourceAgreeContractItemRspBO rspBO = new DycContractImportNoSourceAgreeContractItemRspBO();
        rspBO.setMessage("\u65e0\u6e90\u534f\u8bae\u5408\u540c\u660e\u7ec6\u5bfc\u5165\u6210\u529f");
        rspBO.setCode("0000");
        rspBO.setRows(rows);
        return rspBO;
    }

    public void validate(DycContractImportNoSourceAgreeContractItemReqBO reqBO) {
        if (reqBO.getFileUrl() == null) {
            throw new ZTBusinessException("\u65e0\u6e90\u534f\u8bae\u5408\u540c\u660e\u7ec6\u5bfc\u5165-fileUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Integer stringToInteger(String a) {
        if ("".equals(a)) {
            return null;
        }
        return Double.valueOf(a).intValue();
    }

    public BigDecimal stringToBig(String a) {
        if ("".equals(a)) {
            return null;
        }
        return new BigDecimal(Double.valueOf(a));
    }
}

