/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.order.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEsCheckOrdersFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrderEntity;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrdersFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEsCheckOrdersFuncRspBO;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.estore.order.api.DycUocGetOutCheckOrderService;
import com.tydic.dyc.estore.order.bo.DycUocGetOutCheckOrderServiceReqBO;
import com.tydic.dyc.estore.order.bo.DycUocGetOutCheckOrderServiceRspBO;
import com.tydic.dyc.oc.service.checkorder.UocCreateOutCheckOrderService;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateOutCheckOrderServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateOutCheckOrderServiceRspBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocOutCheckOrderBo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.estore.order.api.DycUocGetOutCheckOrderService"})
public class DycUocGetOutCheckOrderServiceImpl
implements DycUocGetOutCheckOrderService {
    @Autowired
    private DycUocEsCheckOrdersFunction dycUocEsCheckOrdersFunction;
    @Autowired
    private UocCreateOutCheckOrderService uocCreateOutCheckOrderService;

    @Override
    @PostMapping(value={"getOutCheckOrderService"})
    public DycUocGetOutCheckOrderServiceRspBO getOutCheckOrderService(@RequestBody DycUocGetOutCheckOrderServiceReqBO reqBO) {
        DycUocGetOutCheckOrderServiceRspBO rspBO = new DycUocGetOutCheckOrderServiceRspBO();
        List<DycUocEsCheckOrdersFuncRspBO> esCheckOrdersFuncRspBOList = this.getEsCheckOrders(reqBO);
        for (DycUocEsCheckOrdersFuncRspBO esCheckOrdersFuncRspBO : esCheckOrdersFuncRspBOList) {
            this.createCheckOrder(esCheckOrdersFuncRspBO, reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<DycUocEsCheckOrdersFuncRspBO> getEsCheckOrders(DycUocGetOutCheckOrderServiceReqBO reqBO) {
        ArrayList<DycUocEsCheckOrdersFuncRspBO> esCheckOrdersFuncRspBOList = new ArrayList<DycUocEsCheckOrdersFuncRspBO>();
        for (Integer checkType : reqBO.getCheckTypeList()) {
            DycUocEsCheckOrdersFuncReqBO funcFuncReqBO = new DycUocEsCheckOrdersFuncReqBO();
            funcFuncReqBO.setSupNo(reqBO.getSupNo());
            LocalDate localDate = LocalDate.now().minusDays(1L);
            String date = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            funcFuncReqBO.setDate(date);
            if (checkType == 1) {
                funcFuncReqBO.setCallUrl(DycPropertiesUtil.getProperty((String)"ESB_CHECK_NEW_ORDER_URL"));
            } else if (checkType == 2) {
                funcFuncReqBO.setCallUrl(DycPropertiesUtil.getProperty((String)"ESB_CHECK_DLOK_ORDER_URL"));
            } else if (checkType == 3) {
                funcFuncReqBO.setCallUrl(DycPropertiesUtil.getProperty((String)"ESB_CHECK_REFUSE_ORDER_URL"));
            } else if (checkType == 4) {
                funcFuncReqBO.setCallUrl(DycPropertiesUtil.getProperty((String)"ESB_CHECK_AFTER_ORDER_URL"));
            }
            DycUocEsCheckOrdersFuncRspBO funcFuncRspBO = this.dycUocEsCheckOrdersFunction.checkOrder(funcFuncReqBO);
            if (!funcFuncRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException("\u65b0\u5efa\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38" + funcFuncRspBO.getRespDesc());
            }
            funcFuncRspBO.setCheckType(checkType);
            esCheckOrdersFuncRspBOList.add(funcFuncRspBO);
        }
        return esCheckOrdersFuncRspBOList;
    }

    private void createCheckOrder(DycUocEsCheckOrdersFuncRspBO esCheckOrdersFuncRspBO, DycUocGetOutCheckOrderServiceReqBO reqBO) {
        List esCheckOrderEntityList = esCheckOrdersFuncRspBO.getOrders();
        UocCreateOutCheckOrderServiceReqBo uocCreateCheckOrderServiceReqBo = new UocCreateOutCheckOrderServiceReqBo();
        ArrayList<UocOutCheckOrderBo> uocCheckOrderBos = new ArrayList<UocOutCheckOrderBo>();
        for (DycUocEsCheckOrderEntity esCheckOrderEntity : esCheckOrderEntityList) {
            UocOutCheckOrderBo uocCheckOrderBo = new UocOutCheckOrderBo();
            uocCheckOrderBo.setId(Long.valueOf(IdUtil.nextId()));
            uocCheckOrderBo.setOutOrderId(esCheckOrderEntity.getOrderId());
            uocCheckOrderBo.setOutOrderPrice(esCheckOrderEntity.getOrderPrice());
            uocCheckOrderBo.setOutOrderState(esCheckOrderEntity.getState());
            uocCheckOrderBo.setHangUpState(esCheckOrderEntity.getHangUpState());
            uocCheckOrderBo.setOutOrderTime(esCheckOrderEntity.getOrderTime());
            uocCheckOrderBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
            uocCheckOrderBo.setCheckType(esCheckOrdersFuncRspBO.getCheckType());
            uocCheckOrderBos.add(uocCheckOrderBo);
        }
        uocCreateCheckOrderServiceReqBo.setOrderBos(uocCheckOrderBos);
        UocCreateOutCheckOrderServiceRspBo uocCreateCheckOrderServiceRspBo = this.uocCreateOutCheckOrderService.createOutCheckOrder(uocCreateCheckOrderServiceReqBo);
        if (!uocCreateCheckOrderServiceRspBo.getRespCode().equals("0000")) {
            throw new ZTBusinessException("\u5bf9\u8d26\u8ba2\u5355\u4fe1\u606f\u5165\u5e93\u5f02\u5e38\uff1a" + uocCreateCheckOrderServiceRspBo.getRespDesc());
        }
    }
}

