/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.plan.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.plan.api.DycPlanOrgConfigAddService;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigAddReqBO;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigAddRspBO;
import com.tydic.dyc.plan.bo.DycPlanOrgConfigDetailsBO;
import com.tydic.ppc.ability.api.PpcPlanOrgConfigAddAbilityService;
import com.tydic.ppc.ability.bo.PpcPlanOrgConfigAddAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPlanOrgConfigAddAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.plan.api.DycPlanOrgConfigAddService"})
public class DycPlanPlanOrgConfigAddServiceImpl
implements DycPlanOrgConfigAddService {
    private static final Logger log = LoggerFactory.getLogger(DycPlanPlanOrgConfigAddServiceImpl.class);
    @Autowired
    private PpcPlanOrgConfigAddAbilityService ppcPlanOrgConfigAddAbilityService;

    @Override
    @PostMapping(value={"addPlanOrgConfig"})
    public DycPlanOrgConfigAddRspBO addPlanOrgConfig(@RequestBody DycPlanOrgConfigAddReqBO reqBo) {
        log.debug("reqBo==========================" + JSON.toJSONString((Object)reqBo));
        this.validators(reqBo);
        String json = JSON.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        log.debug("json=============================" + json);
        PpcPlanOrgConfigAddAbilityReqBO addAbilityReqBo = (PpcPlanOrgConfigAddAbilityReqBO)JSONObject.parseObject((String)json, PpcPlanOrgConfigAddAbilityReqBO.class);
        PpcPlanOrgConfigAddAbilityRspBO result = this.ppcPlanOrgConfigAddAbilityService.addPlanOrgConfig(addAbilityReqBo);
        if (!"0000".equals(result.getRespCode())) {
            throw new ZTBusinessException(result.getRespDesc());
        }
        DycPlanOrgConfigAddRspBO rspBo = new DycPlanOrgConfigAddRspBO();
        rspBo.setCode("0000");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void validators(DycPlanOrgConfigAddReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrgId() == null) {
            throw new ZTBusinessException("\u5165\u53c2 OrgId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrgName() == null) {
            throw new ZTBusinessException("\u5165\u53c2 OrgName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getPlanOrgConfigDetailsBo())) {
            throw new ZTBusinessException("\u5165\u53c2PlanOrgConfigDetailsBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycPlanOrgConfigDetailsBO bo : reqBO.getPlanOrgConfigDetailsBo()) {
            if (bo.getCompanyNameReq() == null) {
                throw new ZTBusinessException("\u5165\u53c2 CompanyId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getCompanyNameReq() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2 CompanyName \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

