/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.UpdateContractInfoAbilityService;
import com.tydic.contract.ability.bo.UpdateContractInfoAbilityReqBO;
import com.tydic.contract.ability.bo.UpdateContractInfoAbilityRspBO;
import com.tydic.dyc.agr.service.agr.AgrDeleteAgrService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrRelBo;
import com.tydic.dyc.zone.agr.api.DycAgrAgrDeleteService;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrDeleteReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrDeleteRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrAgrDeleteService"})
public class DycAgrAgrDeleteServiceImpl
implements DycAgrAgrDeleteService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrAgrDeleteServiceImpl.class);
    @Autowired
    private AgrDeleteAgrService agrDeleteAgrService;
    @Autowired
    private AgrGetAgrDetailService agrGetAgrDetailService;
    @Autowired
    private UpdateContractInfoAbilityService updateContractInfoAbilityService;
    private static final Integer IS_QUOTE_FLAG = 0;

    @Override
    @PostMapping(value={"dealAgrDelete"})
    public DycAgrAgrDeleteRspBO dealAgrDelete(@RequestBody DycAgrAgrDeleteReqBO reqBO) {
        AgrDeleteAgrReqBo agrReqBo = (AgrDeleteAgrReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), AgrDeleteAgrReqBo.class);
        ArrayList<Long> contractIds = new ArrayList<Long>();
        reqBO.getAgrIds().forEach(agrId -> {
            Long contractId = this.getContractIds((Long)agrId);
            if (contractId != null) {
                contractIds.add(contractId);
            }
            agrReqBo.setAgrId(agrId);
            AgrDeleteAgrRspBo rspBo = this.agrDeleteAgrService.deleteAgr(agrReqBo);
            if (!"0000".equals(rspBo.getRespCode())) {
                throw new ZTBusinessException(rspBo.getRespDesc());
            }
        });
        this.updateContractInfo(contractIds);
        return new DycAgrAgrDeleteRspBO();
    }

    private void updateContractInfo(List<Long> contractIds) {
        if (ObjectUtil.isNotEmpty(contractIds)) {
            contractIds.forEach(contractId -> {
                UpdateContractInfoAbilityReqBO updateContractInfoAbilityReqBO = new UpdateContractInfoAbilityReqBO();
                updateContractInfoAbilityReqBO.setContractId(contractId);
                updateContractInfoAbilityReqBO.setIsQuoteFlag(IS_QUOTE_FLAG);
                log.debug("\u8c03\u7528\u5408\u540c\u540c\u6b65\u5165\u53c2================================" + updateContractInfoAbilityReqBO);
                UpdateContractInfoAbilityRspBO updateContractInfoAbilityRspBO = this.updateContractInfoAbilityService.updateContractInfo(updateContractInfoAbilityReqBO);
                log.debug("\u8c03\u7528\u5408\u540c\u540c\u6b65\u51fa\u53c2================================" + updateContractInfoAbilityRspBO);
                if (!"0000".equals(updateContractInfoAbilityRspBO.getRespCode())) {
                    throw new ZTBusinessException(updateContractInfoAbilityRspBO.getRespDesc());
                }
            });
        }
    }

    private Long getContractIds(Long agrId) {
        String objId = "";
        AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
        agrGetAgrDetailReqBo.setAgrId(agrId);
        AgrGetAgrDetailRspBo agrDetail = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
        if (!"0000".equals(agrDetail.getRespCode())) {
            throw new ZTBusinessException(agrDetail.getRespDesc());
        }
        List agrRel = agrDetail.getAgrRel();
        if (ObjectUtil.isNotEmpty((Object)agrRel)) {
            objId = ((AgrRelBo)agrRel.get(0)).getObjId();
        }
        return !"".equals(objId) && objId != null ? Long.valueOf(objId) : null;
    }
}

