/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrCreateReferenceAgrService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrCodeService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.zone.agr.api.DycAgrCreateReferenceAgrService;
import com.tydic.dyc.zone.agr.bo.DycAgrCreateReferenceAgrReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrCreateReferenceAgrRspBO;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrCreateReferenceAgrService"})
public class DycAgrCreateReferenceAgrServiceImpl
implements DycAgrCreateReferenceAgrService {
    @Autowired
    private AgrCreateReferenceAgrService agrCreateReferenceAgrService;
    @Autowired
    private AgrGetAgrCodeService agrGetAgrCodeService;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;

    @Override
    @PostMapping(value={"createReferenceAgr"})
    public DycAgrCreateReferenceAgrRspBO createReferenceAgr(@RequestBody DycAgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO) {
        if (agrCreateReferenceAgrReqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e3a\u7a7a");
        }
        if (agrCreateReferenceAgrReqBO.getAgrId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[agrId]\u4e3a\u7a7a");
        }
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.getAgrMain(agrCreateReferenceAgrReqBO.getAgrId());
        String agrCode = this.getAgrCode(agrCreateReferenceAgrReqBO, agrGetAgrMainRspBo);
        Long agrId = this.invokeReferenceAgrCreate(agrCreateReferenceAgrReqBO, agrCode);
        this.startBusiProcess(agrCreateReferenceAgrReqBO, agrId, agrCode, agrGetAgrMainRspBo.getTradeMode());
        DycAgrCreateReferenceAgrRspBO rspBO = new DycAgrCreateReferenceAgrRspBO();
        rspBO.setAgrId(agrId);
        return rspBO;
    }

    private void startBusiProcess(DycAgrCreateReferenceAgrReqBO reqBO, Long newAgrId, String agrCode, Integer tradeMode) {
        DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
        if (tradeMode.equals(1)) {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_plat_agr_busi_process");
        } else {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_danwei_agr_busi_process");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("agrId", newAgrId);
        variables.put("orderId", newAgrId);
        variables.put("auditObjId", newAgrId);
        variables.put("auditObjType", AgrCommConstant.ObjType.AGREEMENT);
        variables.put("auditObjCode", agrCode);
        variables.put("auditStartFlag", "1");
        variables.put("auditFinishFlag", "1");
        variables.put("orgId", reqBO.getOrgId());
        variables.put("orgName", reqBO.getOrgName());
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("todoOrderNo", agrCode);
        variables.put("createOperId", reqBO.getUserId());
        variables.put("loginTagIn", reqBO.getLoginTagIn());
        variables.put("agrType", AgrCommConstant.AgrType.REFERENCE_AGR);
        dycBusiProcessStartFuncReqBO.setVariables(variables);
        dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
        dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(newAgrId));
        DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u63d0\u4ea4\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
        }
    }

    private AgrGetAgrMainRspBo getAgrMain(Long agrId) {
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(agrId);
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrGetAgrMainRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + agrGetAgrMainRspBo.getRespCode() + "\u3011," + agrGetAgrMainRspBo.getRespDesc());
        }
        if (agrGetAgrMainRspBo.getAgrId() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return agrGetAgrMainRspBo;
    }

    private Long invokeReferenceAgrCreate(DycAgrCreateReferenceAgrReqBO reqBO, String agrCode) {
        AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO = (AgrCreateReferenceAgrReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), AgrCreateReferenceAgrReqBO.class);
        agrCreateReferenceAgrReqBO.setAgrCode(agrCode);
        AgrCreateReferenceAgrRspBO rspBO = this.agrCreateReferenceAgrService.createReferenceAgr(agrCreateReferenceAgrReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        return rspBO.getAgrId();
    }

    private String getAgrCode(DycAgrCreateReferenceAgrReqBO reqBO, AgrGetAgrMainRspBo AgrGetAgrMainRspBo2) {
        AgrGetAgrCodeReqBO agrGetAgrCodeReqBO = (AgrGetAgrCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), AgrGetAgrCodeReqBO.class);
        agrGetAgrCodeReqBO.setAgrCode(AgrGetAgrMainRspBo2.getAgrCode());
        agrGetAgrCodeReqBO.setEncodedRuleCode("ARG_QUOTE_AGREEMENT_CODE");
        AgrGetAgrCodeRspBO agrGetAgrCodeRspBO = this.agrGetAgrCodeService.getAgrCode(agrGetAgrCodeReqBO);
        if (!"0000".equals(agrGetAgrCodeRspBO.getRespCode())) {
            throw new ZTBusinessException(agrGetAgrCodeRspBO.getRespDesc());
        }
        return agrGetAgrCodeRspBO.getPlaAgreementCode();
    }
}

