/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.atom.selfrun.api.DycSendNoticeFunction;
import com.tydic.dyc.atom.selfrun.bo.DycReceiverFuncBo;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.zone.agr.api.DycAgrSendNoticeByOrgIdAndRoleService;
import com.tydic.dyc.zone.agr.bo.DycAgrNoticeConfigBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSendNoticeByOrgIdAndRoleReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSendNoticeByOrgIdAndRoleRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrSendNoticeByOrgIdAndRoleService"})
public class DycAgrSendNoticeByOrgIdAndRoleServiceImpl
implements DycAgrSendNoticeByOrgIdAndRoleService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrSendNoticeByOrgIdAndRoleServiceImpl.class);
    @Autowired
    private DycSendNoticeFunction dycSendNoticeFunction;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private AgrGetAgrChngApplyDetailService agrGetAgrChngApplyDetailService;

    @Override
    @PostMapping(value={"sendNoticeByOrgIdAndRole"})
    public DycAgrSendNoticeByOrgIdAndRoleRspBO sendNoticeByOrgIdAndRole(@RequestBody DycAgrSendNoticeByOrgIdAndRoleReqBO reqBO) {
        log.info("DycAgrSendNoticeByOrgIdAndRoleService\u670d\u52a1\u5165\u53c2\u4e3a: {}", (Object)JSON.toJSONString((Object)reqBO));
        this.check(reqBO);
        Map<String, String> dataMap = this.buildTemplateParam(reqBO);
        if (reqBO.getAuditResult().equals(1)) {
            for (DycAgrNoticeConfigBO configBO : reqBO.getPassNoticeConfigs()) {
                this.sendNotice(dataMap, configBO);
            }
        }
        if (reqBO.getAuditResult().equals(0)) {
            for (DycAgrNoticeConfigBO configBO : reqBO.getRejectNoticeConfigs()) {
                this.sendNotice(dataMap, configBO);
            }
        }
        DycAgrSendNoticeByOrgIdAndRoleRspBO rspBO = new DycAgrSendNoticeByOrgIdAndRoleRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendNotice(Map<String, String> dataMap, DycAgrNoticeConfigBO configBO) {
        List<DycReceiverFuncBo> receiverFuncBoList = this.getNoticeReceiver(configBO, dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskCode", configBO.getTaskCode());
        map.put("data", dataMap);
        map.put("sendId", 1L);
        map.put("sendName", "admin");
        map.put("receiverIdList", JSON.toJSONString(receiverFuncBoList));
        log.info("DycAgrSendNoticeByOrgIdAndRoleService\u53d1\u9001\u6d88\u606f\u901a\u77e5map\uff1a {}", (Object)JSON.toJSONString(map));
        this.dycSendNoticeFunction.sendMessage(map);
    }

    private List<DycReceiverFuncBo> getNoticeReceiver(DycAgrNoticeConfigBO configBO, Map<String, String> dataMap) {
        ArrayList<DycReceiverFuncBo> receiverFuncBoList = new ArrayList<DycReceiverFuncBo>();
        if (configBO.getGetUserType().equals(1)) {
            Long orgId = null;
            if (configBO.getSendOrgType().equals(2)) {
                orgId = Long.valueOf(dataMap.get("createOrgId"));
            } else if (configBO.getSendOrgType().equals(1)) {
                orgId = Long.valueOf(dataMap.get("supplierId"));
            } else if (configBO.getSendOrgType().equals(3)) {
                // empty if block
            }
            AuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.getUserByRoleAndOrg(orgId, configBO.getRoleIds());
            if (!CollectionUtils.isEmpty((Collection)userByRoleAndOrgRspBo.getRows())) {
                for (AuthByRoleAndOrgQryUserInfoBo userInfoBo : userByRoleAndOrgRspBo.getRows()) {
                    DycReceiverFuncBo receiverFuncBo = new DycReceiverFuncBo();
                    receiverFuncBo.setReceiverId(userInfoBo.getUserId() + "");
                    receiverFuncBo.setReceiverName(userInfoBo.getCustName());
                    receiverFuncBo.setMobileNumber(userInfoBo.getCellPhone());
                    receiverFuncBoList.add(receiverFuncBo);
                }
            }
        }
        if (configBO.getGetUserType().equals(2)) {
            DycReceiverFuncBo receiverFuncBo = new DycReceiverFuncBo();
            receiverFuncBo.setReceiverId(dataMap.get("createUserId"));
            receiverFuncBo.setReceiverName(dataMap.get("createUserName"));
            receiverFuncBoList.add(receiverFuncBo);
        }
        return receiverFuncBoList;
    }

    private Map<String, String> buildTemplateParam(DycAgrSendNoticeByOrgIdAndRoleReqBO reqBO) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        dataMap.put("agrCode", agrGetAgrMainRspBo.getAgrCode());
        dataMap.put("agrTypeStr", agrGetAgrMainRspBo.getAgrTypeStr());
        dataMap.put("agrType", agrGetAgrMainRspBo.getAgrType() == null ? null : agrGetAgrMainRspBo.getAgrType().toString());
        dataMap.put("agrName", agrGetAgrMainRspBo.getAgrName());
        dataMap.put("createUserId", agrGetAgrMainRspBo.getCreateLoginId() + "");
        dataMap.put("createUserName", agrGetAgrMainRspBo.getCreateName());
        dataMap.put("createOrgId", agrGetAgrMainRspBo.getCreateOrgId() + "");
        dataMap.put("supplierId", agrGetAgrMainRspBo.getSupplierId() + "");
        AgrGetAgrChngApplyDetailRspBO agrGetAgrChngApplyDetailRspBO = null;
        if (reqBO.getChngApplyId() != null && reqBO.getChngApplyId() != 0L) {
            AgrGetAgrChngApplyDetailReqBO agrGetAgrChngApplyDetailReqBO = new AgrGetAgrChngApplyDetailReqBO();
            agrGetAgrChngApplyDetailReqBO.setChngApplyId(reqBO.getChngApplyId());
            agrGetAgrChngApplyDetailReqBO.setAgrId(reqBO.getAgrId());
            agrGetAgrChngApplyDetailRspBO = this.agrGetAgrChngApplyDetailService.getAgrChngApplyDetail(agrGetAgrChngApplyDetailReqBO);
            dataMap.put("chngApplyNo", agrGetAgrChngApplyDetailRspBO.getChngApplyNo());
        }
        return dataMap;
    }

    private AuthGetUserByRoleAndOrgRspBo getUserByRoleAndOrg(Long orgId, List<Long> roleIdList) {
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setRoleIds(roleIdList);
        authGetUserByRoleAndOrgReqBo.setOrgIdWeb(orgId);
        authGetUserByRoleAndOrgReqBo.setPageNo(-1);
        authGetUserByRoleAndOrgReqBo.setPageSize(-1);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1AuthGetUserByRoleAndOrgService\u5165\u53c2\u4e3a: {}", (Object)JSON.toJSONString((Object)authGetUserByRoleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1AuthGetUserByRoleAndOrgService\u51fa\u53c2\u4e3a: {}", (Object)JSON.toJSONString((Object)userByRoleAndOrgRspBo));
        return userByRoleAndOrgRspBo;
    }

    private void check(DycAgrSendNoticeByOrgIdAndRoleReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getPassNoticeConfigs())) {
            reqBO.setPassNoticeConfigs(JSON.parseArray((String)reqBO.getPassNoticeConfig(), DycAgrNoticeConfigBO.class));
        }
        if (CollectionUtils.isEmpty(reqBO.getRejectNoticeConfigs())) {
            reqBO.setRejectNoticeConfigs(JSON.parseArray((String)reqBO.getRejectNoticeConfig(), DycAgrNoticeConfigBO.class));
        }
        if (reqBO.getAuditResult() == null) {
            throw new ZTBusinessException("\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAuditResult().equals(1) && CollectionUtils.isEmpty(reqBO.getPassNoticeConfigs())) {
            throw new ZTBusinessException("\u901a\u8fc7\u901a\u77e5\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAuditResult().equals(0) && CollectionUtils.isEmpty(reqBO.getRejectNoticeConfigs())) {
            throw new ZTBusinessException("\u9a73\u56de\u901a\u77e5\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

