/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcParamConfigAbilityService;
import com.tydic.cfc.ability.bo.CfcParamConfigItemBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityRspBO;
import com.tydic.dyc.agr.service.agr.AgrAgrInvalidService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.zone.agr.api.DycAgrTimeTaskService;
import com.tydic.dyc.zone.agr.bo.DycAgrGetAgrListRspBO;
import com.tydic.dyc.zone.agr.bo.DycAgrTimeTaskReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrTimeTaskRspBO;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrTimeTaskService"})
public class DycAgrTimeTaskServiceImpl
implements DycAgrTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrTimeTaskServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private AgrUpdateAgrMainService agrUpdateAgrMainService;
    @Autowired
    private AgrSyncUccService agrSyncUccService;
    @Autowired
    private CfcParamConfigAbilityService cfcParamConfigAbilityService;
    @Autowired
    private AgrAgrInvalidService agrAgrInvalidService;
    private static final String qryCode = "551184533233897563";

    @Override
    @PostMapping(value={"timeTaskExecte"})
    public DycAgrTimeTaskRspBO timeTaskExecte(@RequestBody DycAgrTimeTaskReqBO reqBO) {
        JSONObject reqBoJsonObj = new JSONObject();
        reqBoJsonObj.put("dataType", (Object)1);
        reqBoJsonObj.put("code", (Object)qryCode);
        reqBoJsonObj.put("pageNo", (Object)-1);
        reqBoJsonObj.put("pageSize", (Object)5000);
        if (reqBO.getTimeTaskType().equals("1")) {
            Long todayEnd = Timestamp.valueOf(LocalDateTime.of(LocalDateTime.now().toLocalDate(), LocalTime.MAX)).getTime();
            reqBoJsonObj.put("expDateEnd", (Object)todayEnd);
            reqBoJsonObj.put("agrStatus", (Object)AgrCommConstant.AgreementStatus.ENABLE);
        } else if (reqBO.getTimeTaskType().equals("2")) {
            int configDays = 0;
            String configDaysString = null;
            CfcQryParamConfigListAbilityReqBO cfcQryParamConfigListAbilityReqBO = new CfcQryParamConfigListAbilityReqBO();
            cfcQryParamConfigListAbilityReqBO.setParamConfigCode("agr_base_param");
            CfcQryParamConfigListAbilityRspBO cfcQryParamConfigListAbilityRspBO = this.cfcParamConfigAbilityService.qryParamConfigList(cfcQryParamConfigListAbilityReqBO);
            log.info("\u914d\u7f6e\u4e2d\u5fc3\u5ef6\u671f\u914d\u7f6e\u51fa\u53c2" + JSON.toJSONString((Object)cfcQryParamConfigListAbilityRspBO));
            List paramConfigItemList = cfcQryParamConfigListAbilityRspBO.getParamConfigItemList();
            if (paramConfigItemList != null && paramConfigItemList.size() > 0) {
                for (CfcParamConfigItemBO pib : paramConfigItemList) {
                    if (!pib.getItemCode().equals("agr_delay")) continue;
                    configDaysString = pib.getItemValue();
                }
            }
            if (!StringUtils.isEmpty(configDaysString)) {
                configDays = Integer.parseInt(configDaysString);
            }
            Date timeTemp = this.dateAddDay(new Date(), -configDays);
            reqBoJsonObj.put("expDateEnd", (Object)timeTemp);
            reqBoJsonObj.put("agrStatus", (Object)AgrCommConstant.AgreementStatus.BE_OVERDUE);
        } else if (reqBO.getTimeTaskType().equals("3")) {
            reqBoJsonObj.put("effDateEnd", (Object)new Date());
            reqBoJsonObj.put("agrStatus", (Object)AgrCommConstant.AgreementStatus.WAIT_ENABLE);
        } else {
            return new DycAgrTimeTaskRspBO();
        }
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycAgrGetAgrListRspBO dycAgrGetAgrListRspBO = (DycAgrGetAgrListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycAgrGetAgrListRspBO.class));
        if (!CollectionUtils.isEmpty(dycAgrGetAgrListRspBO.getRows())) {
            dycAgrGetAgrListRspBO.getRows().forEach(dycAgrMainDetailBO -> {
                if (reqBO.getTimeTaskType().equals("1")) {
                    AgrInvalidRspBO agrInvalidRspBO = this.dealEnableExpire(dycAgrMainDetailBO.getAgrId());
                    List<Long> agrIdList = new ArrayList<Long>();
                    if (CollectionUtil.isNotEmpty((Collection)agrInvalidRspBO.getAgrMainList())) {
                        agrIdList = agrInvalidRspBO.getAgrMainList().stream().map(AgrMainListBo::getAgrId).collect(Collectors.toList());
                    }
                    this.syncUcc(dycAgrMainDetailBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN, agrIdList, ObjectUtil.isNull((Object)dycAgrMainDetailBO.getUpdateLoginId()) ? null : (ObjectUtil.isNull((Object)dycAgrMainDetailBO.getUpdateLoginId()) ? null : dycAgrMainDetailBO.getUpdateLoginId().toString()), dycAgrMainDetailBO.getUpdateUsername());
                }
                if (reqBO.getTimeTaskType().equals("2")) {
                    this.updateAgrInfo(dycAgrMainDetailBO.getAgrId(), AgrCommConstant.AgreementStatus.TERMINATION);
                    this.syncUcc(dycAgrMainDetailBO.getAgrId(), null, AgrCommConstant.SyncType.INVALID, null, null, null);
                }
                if (reqBO.getTimeTaskType().equals("3")) {
                    this.updateAgrInfo(dycAgrMainDetailBO.getAgrId(), AgrCommConstant.AgreementStatus.ENABLE);
                }
            });
        }
        return new DycAgrTimeTaskRspBO();
    }

    private AgrInvalidRspBO dealEnableExpire(Long agrId) {
        AgrInvalidReqBO agrInvalidReqBO = new AgrInvalidReqBO();
        agrInvalidReqBO.setAgrId(agrId);
        AgrInvalidRspBO agrInvalidRspBO = this.agrAgrInvalidService.dealAgrInvalid(agrInvalidReqBO);
        if (!"0000".equals(agrInvalidRspBO.getRespCode())) {
            throw new ZTBusinessException("\u542f\u52a8\u5230\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u534f\u8bae\u5931\u6548\u670d\u52a1\u5931\u8d25: " + agrInvalidRspBO.getRespDesc());
        }
        return agrInvalidRspBO;
    }

    private void updateAgrInfo(Long agrId, Integer status) {
        AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
        agrUpdateAgrMainReqBO.setAgrId(agrId);
        agrUpdateAgrMainReqBO.setAgrStatus(status);
        AgrUpdateAgrMainRspBO agrUpdateAgrMainRspBO = this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
        if (!"0000".equals(agrUpdateAgrMainRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4e3b\u4f53\u53d8\u66f4\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrUpdateAgrMainRspBO.getRespCode() + "\u3011," + agrUpdateAgrMainRspBO.getRespDesc());
        }
    }

    private void syncUcc(Long agrId, Long chngApplyId, Integer syncType, List<Long> agrIdList, String operId, String operName) {
        AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
        agrSyncUccReqBO.setAgrId(agrId);
        agrSyncUccReqBO.setSyncType(syncType);
        agrSyncUccReqBO.setChngApplyId(chngApplyId);
        agrSyncUccReqBO.setOperId(operId);
        agrSyncUccReqBO.setOperName(operName);
        agrSyncUccReqBO.setAgrIds(agrIdList);
        this.agrSyncUccService.dealAgrSyncUcc(agrSyncUccReqBO);
    }

    private Date dateAddDay(Date time, Integer day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(5, day);
        return cal.getTime();
    }
}

