package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 标题:IUocEsSyncImplShip
 * 说明:发货单
 * 时间:2022/3/1 14:08
 * 作者:罗有
 */
@Slf4j
@Component
public class UocEsSyncShip implements IUocEsSync {

    private static final String SHIP_ORDER_ITEM_KEY = "shipOrderItemBoList";

    private static final String SHIP_ORDER_ITEM_ID_KEY = "shipOrderItemIdList";

    private static final String BUSI_TYPE = "busiType";

    private static final String STREAM_FEE = "streamFee";
    
    private static final String ES_SHIP_ARRIVAL_ORDER_ACCESSORY_KEY = "orderArrivalAccessoryBoList";
    
    private static final String ES_SHIP_REGIST_ORDER_ACCESSORY_KEY = "orderRegistAccessoryBoList";

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocOrderModel iUocOrderModel;


    @Override
    public String indexName() {
        return uocIndexConfig.getShipOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = getShipOrderMain(reqBo);
        if (null == uocShipOrderDo) {
            return iUocEsSyncQryRspBo;
        }

        // 发货时间，如果发货时间没有就只有取发货单创建时间了
        if (uocShipOrderDo.getShipTime() == null) {
            uocShipOrderDo.setShipTime(uocShipOrderDo.getCreateTime());
        }

        Map<String, Map<String, String>> dicMap = getDic();
        JSONObject shipOrder = JSON.parseObject(JSON.toJSONString(uocShipOrderDo));
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> shipOrder.put(uocShipOrderMap.getFieldCode(), uocShipOrderMap.getFieldValue()));
        }
        UocShipOrderDo uocShipOrderDoItem = getShipOrderItem(uocShipOrderDo);
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderDoItem.getShipOrderItemBoList());
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = getSaleItem(uocShipOrderDo);
            JSONArray shipOrdeItemArray = new JSONArray();
            final BigDecimal[] saleFee = {BigDecimal.ZERO};
            final BigDecimal[] purFee = {BigDecimal.ZERO};
            uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
                JSONObject shipOrderItemJson = JSON.parseObject(JSON.toJSONString(uocShipOrderItem));
                if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                    uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> shipOrderItemJson.put(uocShipItemMap.getFieldCode(), uocShipItemMap.getFieldValue()));
                }
                if (ObjectUtil.isNotEmpty(saleItemMap) && saleItemMap.containsKey(uocShipOrderItem.getSaleOrderItemId())) {
                    putSaleItem(shipOrderItemJson, saleItemMap.get(uocShipOrderItem.getSaleOrderItemId()), uocShipOrderItem, uocShipOrderDo);
                    if (!Objects.isNull(shipOrderItemJson.getBigDecimal(UocConstant.ES_MAIN_OTHER.PUR_FEE))){
                        purFee[0] = purFee[0].add(shipOrderItemJson.getBigDecimal(UocConstant.ES_MAIN_OTHER.PUR_FEE));
                    }
                    if (!Objects.isNull(shipOrderItemJson.getBigDecimal(UocConstant.ES_MAIN_OTHER.SALE_FEE))){
                        saleFee[0] = saleFee[0].add(shipOrderItemJson.getBigDecimal(UocConstant.ES_MAIN_OTHER.SALE_FEE));
                    }
                }
                shipOrdeItemArray.add(shipOrderItemJson);
            });
            /*Map<String, List<UocSaleOrderItem>> saleOrderItemsMap = shipOrdeItemArray.toJavaList(UocSaleOrderItem.class).stream()
                    .filter(each -> ObjectUtil.isNotNull(each.getSaleFee())).collect(Collectors.groupingBy(UocSaleOrderItem::getShipItemState));
            //已到货 -> 拒收
            BigDecimal rejectSaleFee = saleOrderItemsMap.get(UocStateConstants.ShipOrder.FH_FH_YSH).stream().map(UocSaleOrderItem::getSaleFee).reduce((a, b) -> a.add(b)).get();
            //已拒收 -> 妥投
            BigDecimal comproSaleFee = saleOrderItemsMap.get(UocStateConstants.ShipOrder.FH_FH_JS).stream().map(UocSaleOrderItem::getSaleFee).reduce((a, b) -> a.add(b)).get();
            if (ObjectUtil.equal(rejectSaleFee.compareTo(comproSaleFee), BigDecimal.ONE.intValue())) {
                shipOrder.put(BUSI_TYPE, "退款");
            } else if (ObjectUtil.equal(rejectSaleFee.compareTo(comproSaleFee), -BigDecimal.ONE.intValue())) {
                shipOrder.put(BUSI_TYPE, "付款");
            }
            shipOrder.put(STREAM_FEE, rejectSaleFee.subtract(comproSaleFee));*/
            shipOrder.put(SHIP_ORDER_ITEM_KEY, shipOrdeItemArray);
            List<String> shipOrderItemList = uocShipOrderDoItem.getShipOrderItemIdList().stream().map(Objects::toString).collect(Collectors.toList());
            shipOrder.put(SHIP_ORDER_ITEM_ID_KEY, shipOrderItemList);
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, saleFee[0]);
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, purFee[0]);
        }
        putOutOrderInfo(reqBo, shipOrder);
        putSaleOrder(uocShipOrderDo, shipOrder, dicMap);
        putAfOrder(uocShipOrderDo, shipOrder);
        putAfInspOrder(uocShipOrderDoItem, shipOrder);
        //执行单
//        putImplOrder(uocShipOrderDo, shipOrder);
        //任务实例
        putTask(reqBo, shipOrder);
        ///附件
        //查询到货确认附件列表，并放入发货单es中
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        accessoryQryBo.setObjId(uocShipOrderDo.getSaleOrderId());
        accessoryQryBo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_CONFIRM);
        List<UocOrderAccessory> accessoryList =  iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if(ObjectUtil.isNotEmpty(accessoryList)){
            shipOrder.put(ES_SHIP_ARRIVAL_ORDER_ACCESSORY_KEY,JSONArray.parseArray(JSON.toJSONString(accessoryList)));
        }
        //查询到货登记附件列表，并放入发货单es中
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        accessoryQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        accessoryQryBo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
        accessoryList =  iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if(ObjectUtil.isNotEmpty(accessoryList)){
            shipOrder.put(ES_SHIP_REGIST_ORDER_ACCESSORY_KEY,JSONArray.parseArray(JSON.toJSONString(accessoryList)));
        }

        //定义发货单附件查询参数
        UocOrderAccessoryQryBo shipOrderAccessoryQry = new UocOrderAccessoryQryBo();
        //设置单据类型
        shipOrderAccessoryQry.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        //设置单据ID
        shipOrderAccessoryQry.setObjId(uocShipOrderDo.getShipOrderId());
        //设置附件类型
        shipOrderAccessoryQry.setAttachmentType(UocAttachementTypeConstants.DELIVERY);
        //调用查询订单附件
        List<UocOrderAccessory> shipOrderAccessoryList = iUocOrderModel.getOrderAccessoryList(shipOrderAccessoryQry);

        if (!CollectionUtils.isEmpty(shipOrderAccessoryList)) {
            //设置发货单附件信息
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SHIP_DELIVERY_ORDER_ACCESSORY_LIST, JSON.parseArray(JSON.toJSONString(shipOrderAccessoryList)));
        }

        /**
         * 翻译
         */
        putStr(shipOrder, uocShipOrderDo, dicMap);
        putEnableStateChngFlag(uocShipOrderDo, shipOrder);
        
        //到货登记附件信息
        putArriveRegistAccessoryList(uocShipOrderDo,shipOrder);

        //设置售后时限
        this.putAfLimitTime(shipOrder, uocShipOrderDo);

        iUocEsSyncQryRspBo.setJsonObj(shipOrder);
        log.info("发货单ES数据:{}", shipOrder.toJSONString());
        return iUocEsSyncQryRspBo;
    }

    private void putEnableStateChngFlag(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        shipOrder.put(UocConstant.ES_MAIN_OTHER.ENABLE_STAT_CHNG, true);
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        List<UocAfOrderObj> afOrderObjList = iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
        if (CollectionUtil.isNotEmpty(afOrderObjList)) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
            uocAfOrderQryBo.setAfOrderId(afOrderObjList.get(0).getAfOrderId());
            UocAfOrder afOrderById = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            Integer servState = afOrderById.getServState();
            if (!UocDicConstant.SERVICE_STATE.CANCEL.equals(servState)) {
                shipOrder.put(UocConstant.ES_MAIN_OTHER.ENABLE_STAT_CHNG, false);
            }
        }
        //该发货单是否存在在途变更标识
        BigDecimal decimal = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getChngingCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        shipOrder.put(UocConstant.ES_MAIN_OTHER.PROGRESS_CHNG_FLAG,decimal.compareTo(BigDecimal.ZERO)==0 ? false:true);
    }

    private void putArriveRegistAccessoryList(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder){
        UocOrderAccessoryQryBo bo = new UocOrderAccessoryQryBo();
        bo.setOrderId(uocShipOrderDo.getOrderId());
        bo.setObjId(uocShipOrderDo.getShipOrderId());
        bo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
        List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(bo);
        log.info("到货登记附件出参："+JSON.toJSONString(orderAccessoryList));
        if(!CollectionUtils.isEmpty(orderAccessoryList)){
            shipOrder.put(UocConstant.ES_MAIN_OTHER.ARRIVE_REGIST_ACCESSORY,orderAccessoryList);
        }
    }

    private void putAfOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        List<UocAfOrder> afOrderList = getAfOrderList(uocShipOrderDo);
    
        Boolean isAfFinishFlag = false;
        if (ObjectUtil.isNotEmpty(afOrderList)) {
            for (UocAfOrder afOrder:afOrderList){
                if (Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_PASS)
                        || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.REMARK_COMPLATE)) {
                    //有未完结的售后单
                    isAfFinishFlag = true;
                }
            }
        }
        shipOrder.put(UocConstant.ES_MAIN_OTHER.IS_AF_FINISH, isAfFinishFlag);
        shipOrder.put(UocConstant.ES_MAIN_OTHER.IS_AF_FINISH_STR, isAfFinishFlag ? "是" : "否");
    }

    private List<UocAfOrder> getAfOrderList(UocShipOrderDo uocShipOrderDo) {
        //查询该发货单下的售后单
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        List<UocAfOrderObj> afOrderObjList = iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
        List<UocAfOrder> afOrderList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(afOrderObjList)){
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
            uocAfOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
            uocAfOrderQryBo.setAfOrderIds(afOrderObjList.stream().map(obj->obj.getAfOrderId()).collect(Collectors.toList()));
            afOrderList = iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        }
        return afOrderList;
    }

    private void putOutOrderInfo(IUocEsSyncQryReqBo reqBo, JSONObject shipOrder) {
        List<UocOrderQueryIndex> queryIndexs = getQueryIndexs(reqBo);
        if (ObjectUtil.isNotEmpty(queryIndexs)) {
            UocOrderQueryIndex queryIndex = queryIndexs.get(0);
            shipOrder.put(UocConstant.ES_MAIN_OTHER.OUT_ORD_ID, queryIndex.getOutObjId());
        }
    }

    private void putAfInspOrder(UocShipOrderDo shipItem, JSONObject shipOrder) {
       //发货单有发货明细，不用校验
        List<UocShipOrderItem> shipList = shipItem.getShipOrderItemBoList();
        long sum = shipList.stream().collect(Collectors.summarizingInt(obj -> (obj.getInspCount()).intValue())).getSum();
        //发货单状态为已到货，但有验收数量，且未完成验收，则该发货单不展示在售后申请列表中
        if(UocStateConstants.ShipOrder.FH_FH_YSH.equals(shipItem.getShipOrderState()) && sum > 0){
            shipOrder.put("shipAfFlag","0");
        }else {
            shipOrder.put("shipAfFlag","1");
        }
    }

    /**
     * 执行单
     *
     * @param uocShipOrderDo
     * @param shipOrder
     */
//    private void putImplOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
//        UocImplOrderDo uocImplOrderDo = getImplOrderMain(uocShipOrderDo);
//        shipOrder.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_NO, null == uocImplOrderDo ? "" : uocImplOrderDo.getImplOrderNo());
//    }

    /**
     * 任务实例
     *
     * @param reqBo
     * @param shipOrder
     */
    private void putTask(IUocEsSyncQryReqBo reqBo, JSONObject shipOrder) {
//        List<UocGetSaleOrderDetailServiceRspTaskBo> busiTaskBoList = getBusiTaskInstList(reqBo);
//        if(ObjectUtil.isNotEmpty(busiTaskBoList)){
//            shipOrder.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, busiTaskBoList.get(0));
//        }

        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(reqBo, false);
        shipOrder.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, busiProcInst.getTaskList());
    }

    /**
     * 销售单信息
     *
     * @param uocShipOrderDo
     * @param shipOrder
     */
    private void putSaleOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder, Map<String, Map<String, String>> dicMap) {
        UocSaleOrderDo uocSaleOrderDo = getSaleOrder(uocShipOrderDo);
        if (null != uocSaleOrderDo) {
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO, uocSaleOrderDo.getSaleOrderNo());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO_EXT, uocSaleOrderDo.getSaleOrderNoExt());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, uocSaleOrderDo.getSaleOrderState());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(uocSaleOrderDo.getSaleOrderState()));
            shipOrder.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_TIME, uocSaleOrderDo.getCreateTime());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_NAME, uocSaleOrderDo.getCreateOperName());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE, uocSaleOrderDo.getOrderSource().toString());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, uocSaleOrderDo.getPayType());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE_STR, dicMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(uocSaleOrderDo.getPayType()));
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PURCHASE_APP_TYPE, uocSaleOrderDo.getPurchaseAppType());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.REDUCE_ACCOUNT, uocSaleOrderDo.getReduceAccount());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PRO_SCHEME_LOT_NO, uocSaleOrderDo.getProSchemeLotNo());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.PRO_SCHEME_NO, uocSaleOrderDo.getProSchemeNo());
            shipOrder.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE, uocSaleOrderDo.getModelSettle());

            //设置翻译
            if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getPurchaseAppType())) {
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PURCHASE_APP_TYPE_STR, dicMap.get(UocDicConstant.PURCHASE_APP_TYPE.P_CODE).get(uocSaleOrderDo.getPurchaseAppType()));
            }
            if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getReduceAccount())) {
                shipOrder.put(UocConstant.ES_MAIN_OTHER.REDUCE_ACCOUNT_STR, dicMap.get(UocDicConstant.REDUCE_ACCOUNT.P_CODE).get(uocSaleOrderDo.getReduceAccount()));
            }

            //供应商订单类型
            if (null != uocSaleOrderDo.getJdCz()) {
                shipOrder.put(UocConstant.ES_MAIN_OTHER.VENDOR_ORD_TYPE, uocSaleOrderDo.getJdCz());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.VENDOR_ORD_TYPE_STR, dicMap.get(UocDicConstant.VENDOR_ORD_TYPE.P_CODE).get(uocSaleOrderDo.getJdCz().toString()));
            }
            UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
            if (null != stakeholder) {
                shipOrder.put(UocConstant.ES_MAIN_OTHER.SUP_ID, stakeholder.getSupId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, stakeholder.getSupName());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PRO_ID, stakeholder.getProId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_ID, stakeholder.getPurCompanyId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_NAME, stakeholder.getPurCompanyName());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_NO, stakeholder.getPurCompanyNo());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, stakeholder.getPurUserId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, stakeholder.getPurOrgId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, stakeholder.getPurOrgName());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NO, stakeholder.getPurOrgNo());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_PATH, stakeholder.getPurOrgPath());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.SUP_ORG_PATH, stakeholder.getSupOrgPath());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PRO_ORG_PATH, stakeholder.getProOrgPath());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_COMP_ID, stakeholder.getPurCompanyId());
                shipOrder.put(UocConstant.ES_MAIN_OTHER.PUR_COMP_NAME, stakeholder.getPurCompanyName());
            }
        }
    
        //查询销售单扩展
        List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(uocShipOrderDo);
        if (null != saleOrderMapList) {
            saleOrderMapList.forEach(each -> shipOrder.put(each.getFieldCode(), each.getFieldValue()));
        }
    }
    
    /**
     * 查询销售单扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap
     */
    private List<UocSaleOrderMap> getSaleOrderMapList(UocShipOrderDo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        
        return iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }
    
    private void putStr(JSONObject shipOrder, UocShipOrderDo uocShipOrderDo, Map<String, Map<String, String>> dicMap) {
        Map<String, String> shipStateMap = dicMap.get(UocStateConstants.ShipOrder.P_CODE);
        shipOrder.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_STATE_STR, ObjectUtil.isNotEmpty(shipStateMap) ? shipStateMap.get(uocShipOrderDo.getShipOrderState()) : "");
    }

    private void putSaleItem(JSONObject shipOrderItemJson, UocSaleOrderItem uocSaleOrderItem, UocShipOrderItem uocShipOrderItem, UocShipOrderDo uocShipOrderDo) {
        if (null != uocSaleOrderItem) {
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_ID, uocSaleOrderItem.getSupplierId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_SHOP_ID, uocSaleOrderItem.getSupplierShopId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, uocSaleOrderItem.getCommodityId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_CODE, uocSaleOrderItem.getCommodityCode());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, uocSaleOrderItem.getCommodityName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_TYPE_ID, uocSaleOrderItem.getCommodityTypeId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_ID, uocSaleOrderItem.getSkuId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_CODE, uocSaleOrderItem.getSkuCode());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_ID, uocSaleOrderItem.getSkuMaterialId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_CODE, uocSaleOrderItem.getSkuMaterialCode());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MAIN_PIC_URL, uocSaleOrderItem.getSkuMainPicUrl());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_NAME, uocSaleOrderItem.getSkuMaterialName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_ID, uocSaleOrderItem.getSkuMaterialTypeId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_NAME, uocSaleOrderItem.getSkuMaterialTypeName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX, uocSaleOrderItem.getTax());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_ID, uocSaleOrderItem.getTaxId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_PRICE, uocSaleOrderItem.getTaxPrice());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG, uocSaleOrderItem.getL1Catalog());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG_NAME, uocSaleOrderItem.getL1CatalogName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG, uocSaleOrderItem.getL2Catalog());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG_NAME, uocSaleOrderItem.getL2CatalogName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG, uocSaleOrderItem.getL3Catalog());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG_NAME, uocSaleOrderItem.getL3CatalogName());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.UNIT_DIGIT, StringUtils.isEmpty(uocSaleOrderItem.getUnitDigit()) ? "" : uocSaleOrderItem.getUnitDigit());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_EXT_SKU_ID, uocSaleOrderItem.getSkuExtSkuId());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.GOODS_WEIGHT, uocSaleOrderItem.getGoodsWeight());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TOTAL_GOODS_WEIGHT, uocSaleOrderItem.getTotalGoodsWeight());
            //若发货单状态为已到货时，可售后数量=本次发货数量-已退货数量-售后中数量
            BigDecimal afterCountEnable = BigDecimal.ZERO;
//            if (UocStateConstants.ShipOrder.FH_FH_YSH.equals(uocShipOrderDo.getShipOrderState())) {
//                if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
//                    afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
//                }
//            }
//            //若发货单状态为已验收时，可售后数量=实际验收数量-已退货数量-售后中数量
//            if (UocStateConstants.ShipOrder.FH_FH_YS.equals(uocShipOrderDo.getShipOrderState())) {
//                if (uocShipOrderItem.getInspCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
//                    afterCountEnable = uocShipOrderItem.getInspCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
//                }
//            }
            if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
                afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
            }
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.AVAILABLE_AF_SERV_COUNT, afterCountEnable);
            if (null != uocSaleOrderItem.getSalePrice() && null != uocShipOrderItem.getSendCount()) {
                shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, uocSaleOrderItem.getSalePrice().multiply(uocShipOrderItem.getSendCount()));
            }
            if (null != uocSaleOrderItem.getPurchasePrice() && null != uocShipOrderItem.getSendCount()) {
                shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, uocSaleOrderItem.getPurchasePrice().multiply(uocShipOrderItem.getSendCount()));
            }
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocSaleOrderItem.getPurchasePrice());
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PUR_COUNT, uocSaleOrderItem.getPurchaseCount());
            //退货时间，空代表不支持
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.REJECT_ALLOW_DATE, uocSaleOrderItem.getRejectAllowDate());
            //换货时间，空代表不支持
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.EXCHANGE_ALLOW_DATE, uocSaleOrderItem.getExchangeAllowDate());
            //维修时间，空代表不支持
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.MAINTAIN_ALLOW_DATE, uocSaleOrderItem.getMaintainAllowDate());
            //预计送达时间
            shipOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PRE_OFFER_TIME, uocSaleOrderItem.getPreOfferTime());
        }
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<>();
    }

    private UocSaleOrderDo getSaleOrder(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocOrderQueryIndex> getQueryIndexs(IUocEsSyncQryReqBo reqBo) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        return iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    /**
     * 查询发货单明细
     *
     * @param uocShipOrderDo
     * @return
     */
    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    /**
     * 查询发货单主体
     *
     * @param reqBo
     * @return
     */
    private UocShipOrderDo getShipOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getObjId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    /**
     * 查询执行单主体
     */
//    private UocImplOrderDo getImplOrderMain(UocShipOrderDo uocShipOrderDo) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setImplOrderId(uocShipOrderDo.getImplOrderId());
//        uocImplOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
//        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
//    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REDUCE_ACCOUNT.P_CODE);
        pCodes.add(UocDicConstant.PURCHASE_APP_TYPE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocGetSaleOrderDetailServiceRspTaskBo> getBusiTaskInstList(IUocEsSyncQryReqBo reqBo) {
        List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getOrderId());
        taskInstQryBo.setObjId(reqBo.getObjId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<Integer> finishTagList = new ArrayList<>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        taskInstQryBo.setFinishTagList(finishTagList);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
            taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
            taskBoList.forEach(each -> {
                UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                taskDealQryBo.setTaskInstId(each.getTaskInstId());
                taskDealQryBo.setObjId(each.getObjId());
                taskDealQryBo.setObjType(each.getObjType());
                List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
            });
        }
        return taskBoList;
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });

                //为了联调，先取第一个环节编码和任务id
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    /**
     * 设置售后时限
     */
    private void putAfLimitTime(JSONObject shipOrder, UocShipOrderDo uocShipOrderDo) {
        //判断是否有到货时间
        if (ObjectUtil.isNotEmpty(uocShipOrderDo.getArriveTime())) {
            //定义时间日期操作类
            Calendar calendar = Calendar.getInstance();
            //设置到货时间
            calendar.setTime(uocShipOrderDo.getArriveTime());
            //增加 14 天
            calendar.add(Calendar.DAY_OF_MONTH, 14);
            //返回售后时限
            Date afLimitTime = calendar.getTime();

            //设置售后时限
            shipOrder.put(UocConstant.ES_MAIN_OTHER.AF_LIMIT_TIME, afLimitTime);
        }
    }
}
