package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 标题:UocCancelBargainingTransaction
 * 说明:
 * 时间:2023/11/17 15:16
 * 作者:Dum
 */
@Component
@Slf4j
public class UocCancelBargainingTransaction {

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    /**
     * 描述： 终止议价单
     *
     **/
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCancelBargainingRspBo cancelBargaining(UocCancelBargainingReqBo uocCancelBargainingReqBo) {
        //1 参数校验
        this.verifyParam(uocCancelBargainingReqBo);
        //2 前置状态校验
        this.verifyState(uocCancelBargainingReqBo);
        //2 .修改状态
        this.updateBargainingState(uocCancelBargainingReqBo);
        //3. 记录操作记录
        insertProgressRecord(uocCancelBargainingReqBo);
        //4. 返回结果
        return UocRu.success(UocCancelBargainingRspBo.class);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyState(UocCancelBargainingReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        UocBargainingDo bargainingDo = uocBargainingModel.qryBargainingBy(uocBargainingDo);
        if(UocStateConstants.BARGAINING_STATES.YJ_YBJ.equals(bargainingDo.getBargainingState()) ||
                UocStateConstants.BARGAINING_STATES.YJ_BJZ.equals(bargainingDo.getBargainingState())){
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "不能终止议价，只能对已报价或报价中的议价单发起终止！");
        }
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocCancelBargainingReqBo reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getBargainingId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "议价单id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getCancelReason())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "终止原因不能为空");
        }
    }
    /**
     * 更新议价单单状态
     * @param reqBO
     */
    private void updateBargainingState(UocCancelBargainingReqBo reqBO){
        UocBargainingDo uocBargainingDo = new UocBargainingDo();
        uocBargainingDo.setUpdateTime(new Date());
        uocBargainingDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setUpdateOperName(reqBO.getName());
        uocBargainingDo.setCancelTime(new Date());
        uocBargainingDo.setCancelReason(reqBO.getCancelReason());
        uocBargainingDo.setCancelOperName(reqBO.getName());
        uocBargainingDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocBargainingDo.setBargainingState(UocStateConstants.BARGAINING_STATES.YJ_YZZ);
        uocBargainingDo.setBargainingId(reqBO.getBargainingId());
        this.uocBargainingModel.updateBargaining(uocBargainingDo);
    }
    /**
     * 记录操作动作
     * @param reqBO
     */
    private void insertProgressRecord(UocCancelBargainingReqBo reqBO){
        //记录操作记录
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CANCEL);
        recordDo.setOperTypeName("议价单终止");
        recordDo.setOperId(Long.valueOf(reqBO.getUserId()));
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("终止原因："+reqBO.getCancelReason());
        uocBargainingModel.insertProgressRecord(recordDo);
    }

}
