package com.tydic.dyc.oc.service.checkorder;

import cn.hutool.core.convert.impl.DateConverter;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderDo;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderModel;
import com.tydic.dyc.oc.service.checkorder.bo.UocOutCheckOrderBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateOutCheckOrderServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateOutCheckOrderServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@HTServiceImpl
public class UocCreateOutCheckOrderServiceImpl implements UocCreateOutCheckOrderService {
    
    @Autowired
    private UocOutCheckOrderModel uocOutCheckOrderModel;
    
    @Override
    public UocCreateOutCheckOrderServiceRspBo createOutCheckOrder(UocCreateOutCheckOrderServiceReqBo reqBo) {
        UocCreateOutCheckOrderServiceRspBo rspBo = UocRu.success(UocCreateOutCheckOrderServiceRspBo.class);
        for(UocOutCheckOrderBo uocOutCheckOrderBo : reqBo.getOrderBos()){
            UocOutCheckOrderDo uocOutCheckOrderDo = UocRu.js(uocOutCheckOrderBo, UocOutCheckOrderDo.class);
            uocOutCheckOrderDo.setOutOrderTime(DateUtils.strToDate(uocOutCheckOrderBo.getOutOrderTime(),"yyyy-MM-dd hh:mm:ss"));
            uocOutCheckOrderModel.createOutCheckOrder(uocOutCheckOrderDo);
        }
        return rspBo;
    }
}
