package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.service.common.bo.UocBatchSaveTodoInfoReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBatchSaveTodoInfoRspBo;
import com.tydic.dyc.oc.service.common.bo.UocTodoBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 描述: 〈领域服务-批量保存待办数据 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@Slf4j
@HTServiceImpl
public class UocBatchSaveTodoInfoServiceImpl implements UocBatchSaveTodoInfoService{
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public UocBatchSaveTodoInfoRspBo batchSaveTodoInfo(UocBatchSaveTodoInfoReqBo uocBatchSaveTodoInfoReqBo) {
        log.info("批量保存待办数据入参");
        validateArgs(uocBatchSaveTodoInfoReqBo);
        List<UocTodo> jsl = UocRu.jsl(uocBatchSaveTodoInfoReqBo.getUocTodoBos(), UocTodo.class);
        uocCommonModel.insertBatchTodo(jsl);
        UocBatchSaveTodoInfoRspBo rspBO = new UocBatchSaveTodoInfoRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        log.info("批量保存待办数据出参");
        return rspBO;
    }
    private void validateArgs(UocBatchSaveTodoInfoReqBo uocBatchSaveTodoInfoReqBo){
        if (null == uocBatchSaveTodoInfoReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocBatchSaveTodoInfoReqBo.getUocTodoBos()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办信息列表不能为空");
        }
        for (UocTodoBo uocTodo : uocBatchSaveTodoInfoReqBo.getUocTodoBos()) {
            if (null == uocTodo.getTodoId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
            }
            if (null == uocTodo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
            }
            if (null == uocTodo.getBusiId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参业务ID不能为空");
            }
        }
    }
}
