package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderPickupBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocAfterOrderConfirmOrRefuseServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/7 20:30
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
@Slf4j
public class UocAfterOrderConfirmOrRefuseServiceImpl implements UocAfterOrderConfirmOrRefuseService {
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocAfterOrderConfirmOrRefuseRspBo dealAfterOrder(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        
        //参数校验
        validateArg(reqBo);
        UocAfterOrderConfirmOrRefuseRspBo rspBo = UocRu.success(UocAfterOrderConfirmOrRefuseRspBo.class);
        //售后单信息，如果拒绝 销售单售后在途数量 减去相应数量
        List<UocAfOrderDo> afOrderDos = buildUpdateBatchAfParam(reqBo);
        iUocAfOrderModel.updateBatchAfOrderMain(afOrderDos);
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            updateAfingCount(reqBo);

            for (UocAfterOrderConfirmOrRefuseReqItemBo afOrderBo : reqBo.getAfOrderList()) {
                //调用修改发货单计算信息
                this.updateShipComputeInfo(afOrderBo.getOrderId(), afOrderBo.getAfOrderId());
            }
        }
        buidRspBo(reqBo, rspBo);
        
        // 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        for (UocAfterOrderConfirmOrRefuseReqItemBo each:reqBo.getAfOrderList()){
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(each.getTaskId());
            taskBos.add(taskBo);
        }
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111l);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);

        
        
        log.info("供应商确认采购申请出参：" + rspBo);
        return rspBo;
    }

    /**
     * 修改发货单计算信息
     */
    private void updateShipComputeInfo(Long orderId, Long afOrderId) {
        //定义根据售后单ID查询售后单信息参数
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        //设置售后单ID
        uocAfOrderQryBo.setAfOrderId(afOrderId);
        //设置订单ID
        uocAfOrderQryBo.setOrderId(orderId);
        //调用根据售后单ID查询售后单信息
        UocAfOrder uocAfOrder = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);

        //判断服务类型是否为退货
        if (!UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(uocAfOrder.getServType())) {
            return;
        }

        //定义查询售后单明细参数
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        //设置售后单ID
        uocAfOrderItemQryBo.setAfOrderId(uocAfOrder.getAfOrderId());
        //设置订单ID
        uocAfOrderItemQryBo.setOrderId(uocAfOrder.getOrderId());
        //调用查询售后单明细
        List<UocAfOrderItem> uocAfOrderItemList = this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);

        //定义查询发货明细参数
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        //设置发货明细ID
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItemList.get(0).getShipItemId());
        //设置订单ID
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItemList.get(0).getOrderId());
        //调用查询发货明细
        List<UocShipOrderItem> uocShipOrderItemList = this.shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);

        //调用修改发货单占用运费
        this.updateShipOccupyTransFee(uocAfOrder, uocShipOrderItemList.get(0).getShipOrderId());

        //调用修改发货单明细已退货明细金额
        this.updateShipItemReturnSendFee(uocAfOrder, uocAfOrderItemList, uocShipOrderItemList.get(0).getShipOrderId());
    }

    /**
     * 修改发货单占用运费
     */
    private void updateShipOccupyTransFee(UocAfOrder uocAfOrder, Long shipOrderId) {
        //定义修改发货单已占用运费参数
        UocShipOrderDo updateOccupyTransFee = new UocShipOrderDo();
        //设置销售单ID
        updateOccupyTransFee.setShipOrderId(shipOrderId);
        //设置订单ID
        updateOccupyTransFee.setOrderId(uocAfOrder.getOrderId());
        //设置已占用运费 返还占用运费 正数转换为负数
        updateOccupyTransFee.setSendOccupyTransFee(uocAfOrder.getReturnTransFee().negate());
        //调用修改发货单占用运费
        this.shipOrderModel.modifyOccupyTransFee(updateOccupyTransFee);
    }

    /**
     * 修改发货单明细已退货明细金额
     */
    private void updateShipItemReturnSendFee(UocAfOrder uocAfOrder, List<UocAfOrderItem> uocAfOrderItemList, Long shipOrderId) {
        //获取发货单明细ID Vs 售后单明细 Map
        Map<Long, List<UocAfOrderItem>> shipItemIdVsAfOrderItemMap = uocAfOrderItemList.stream().collect(Collectors.groupingBy(UocAfOrderItem::getShipItemId));

        //定义发货单明细集合
        List<UocShipOrderItem> uocShipOrderItemList = new ArrayList<>(1);

        //遍历发货单明细ID Vs 售后单明细 Map
        for (Map.Entry<Long, List<UocAfOrderItem>> entry : shipItemIdVsAfOrderItemMap.entrySet()) {
            //定义发货单明细对象
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();

            //获取当前售后单明细 所有销售退款金额
            BigDecimal allRetSaleFee = entry.getValue().stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            //获取当前售后单明细 所有采购退款金额
            BigDecimal allRetPurchaseFee = entry.getValue().stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);

            //设置发货单明细ID
            uocShipOrderItem.setShipOrderItemId(entry.getKey());
            //设置已退货明细销售金额 返还已退货明细金额 正数转换为负数
            uocShipOrderItem.setRetrunSendSaleFee(allRetSaleFee.negate());
            //设置已退货明细采购金额 返还已退货明细金额 正数转换为负数
            uocShipOrderItem.setRetrunSendPurchaseFee(allRetPurchaseFee.negate());

            //添加到发货单明细集合
            uocShipOrderItemList.add(uocShipOrderItem);
        }

        //定义修改发货单明细已退款明细金额参数
        UocShipOrderDo updateItemReturnSendFee = new UocShipOrderDo();
        //设置发货单ID
        updateItemReturnSendFee.setShipOrderId(shipOrderId);
        //设置订单ID
        updateItemReturnSendFee.setOrderId(uocAfOrder.getOrderId());
        //设置发货单明细集合
        updateItemReturnSendFee.setShipOrderItemBoList(uocShipOrderItemList);
        //调用修改发货单明细已退款明细金额
        this.shipOrderModel.modifyItemReturnSendFee(updateItemReturnSendFee);
    }
    
    private void buidRspBo(UocAfterOrderConfirmOrRefuseReqBo reqBo, UocAfterOrderConfirmOrRefuseRspBo rspBo) {
        List<Integer> pickWareTypes = new ArrayList<>();
        List<String> shipOrderItemIds = new ArrayList<>();
        List<String> saleOrderIdList = new ArrayList<>();
        List<UocAfOrderPickupBO> afOrderServiceInfoBoList = new ArrayList<>();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            UocAfOrder afOrderInfo = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            afOrderServiceInfoBoList.add(JSONObject.parseObject(JSON.toJSONString(afOrderInfo), UocAfOrderPickupBO.class));
            pickWareTypes.add(afOrderInfo.getPickwareType());
            saleOrderIdList.add(afOrderInfo.getSaleOrderId() + "-" + afOrderInfo.getOrderId());
            
            UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            uocAfOrderItemQryBo.setAfOrderId(afOrderInfo.getAfOrderId());
            List<UocAfOrderItem> afOrderItemList = iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
            
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderItemId(afOrderItemList.get(0).getShipItemId());
            List<UocShipOrderItem> shipOrderItemList = shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
            
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            shipOrderItemIds.add(uocShipOrderItem.getShipOrderId() + "-" + uocShipOrderItem.getOrderId());
        }
        rspBo.setPickwareType(pickWareTypes);
        rspBo.setAfOrderServiceInfoBoList(afOrderServiceInfoBoList);
        // 组件同步
        //rspBo.setOrderId(reqBo.getAfOrderList().get(0).getOrderId());
        //rspBo.setAfOrderId(reqBo.getAfOrderList().get(0).getAfOrderId());
        rspBo.setAfOrderIdList(reqBo.getAfOrderList().stream().map(obj -> obj.getAfOrderId() + "-" + obj.getOrderId()).collect(Collectors.toList()));
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            rspBo.setSaleOrderIdList(saleOrderIdList.stream().distinct().collect(Collectors.toList()));
            rspBo.setShipOrderIdList(shipOrderItemIds.stream().distinct().collect(Collectors.toList()));
        }
    }
    
    private void updateAfingCount(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        List<UocAfterOrderConfirmOrRefuseReqItemBo> afOrderList = reqBo.getAfOrderList();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : afOrderList) {
            UocAfOrderItemQryBo uocAfOrderQryBo = new UocAfOrderItemQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderQryBo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            List<UocAfOrderItem> afOrderItemList = iUocAfOrderModel.getAfOrderItemList(uocAfOrderQryBo);
            for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
                Long orderItemId = uocAfOrderItem.getSaleItemId();
                BigDecimal returnCount = uocAfOrderItem.getReturnCount();
                Long shipItemId = uocAfOrderItem.getShipItemId();
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocShipOrderItem.setShipOrderItemId(shipItemId);
                uocShipOrderItem.setAfterServingCount(returnCount.negate());
                uocShipOrderItem.setUpdateTime(new Date());
                uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocSaleOrderItem.setSaleOrderItemId(orderItemId);
                uocSaleOrderItem.setAfterServingCount(returnCount.negate());
                uocSaleOrderItem.setUpdateTime(new Date());
                uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            }
        }
    }
    
    private List<UocAfOrderDo> buildUpdateBatchAfParam(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        List<UocAfOrderDo> afOrderDos = new ArrayList<>();
        
        //if (ObjectUtil.isNotEmpty(reqBo.getReturnReason())) {
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            //先查询售后单
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderQryBo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            UocAfOrder qryResult = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            if (null == qryResult) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后单查询为空");
            }
            UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
            uocAfOrderDo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderDo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocAfOrderDo.setReturnReason(reqBo.getReturnReason());
            uocAfOrderDo.setUpdateTime(new Date());
            uocAfOrderDo.setServState(reqBo.getOpFlag().equals(1) ? UocDicConstant.SERVICE_STATE.APPROVAL_PASS : UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
            if (reqBo.getOpFlag() == 0) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
                uocAfOrderDo.setWaybillFlag(0);
                //如果是退货，更新付款状态为已取消
                if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(qryResult.getServType())) {
                    uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
                }
            } else {
                uocAfOrderDo.setWaybillFlag(1);
            }
            // 保存地址
            // 售后退货给供应商的地址(自行寄回)
            if (null != reqBo.getReturnAddress() && null != reqBo.getReturnAddress().getContactProvinceId() && !"".equals(reqBo.getReturnAddress().getContactProvinceId())) {
                long id = IdUtil.nextId();
                uocAfOrderDo.setReturnAddress(UocRu.js(reqBo.getReturnAddress(), UocOrdLogisticsRela.class));
                uocAfOrderDo.getReturnAddress().setContactId(id);
                uocAfOrderDo.getReturnAddress().setOrderId(reqBo.getOrderId());
                uocAfOrderDo.setExtField1(String.valueOf(id));
            }
            afOrderDos.add(uocAfOrderDo);
        }
        // }
        return afOrderDos;
    }
    
    private void validateArg(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型为空");
        }
        if (CollectionUtil.isEmpty(reqBo.getAfOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单据为空");
        }
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            if (null == uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
            }
            if (null == uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单ID为空");
            }
        }
    }
}
