package com.tydic.dyc.oc.service.domainservice;


import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述：字典服务，前端使用
 *
 * @author tkl
 * @date 2022/3/9 14:20
 * <p>
 **/
@HTServiceImpl
public class UocProDictionaryServiceImpl implements UocProDictionaryService {

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocProDictionaryRspBO qryDic(UocProDictionaryReqBO reqBO) {
        UocProDictionaryRspBO rspBO = UocRu.success(UocProDictionaryRspBO.class);
        String validateArgStr = validateQryArg(reqBO);
        if (ObjectUtil.isNotEmpty(validateArgStr)) {
            rspBO.setRespCode(UocRspConstants.RSP_CODE_PEB_DIC_PARAM_ERROR);
            rspBO.setRespDesc("入参校验失败：" + validateArgStr);
            return rspBO;
        }
        List<UocSysDictionaryDo> uocSysDictionaryDos = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(reqBO.getPCode()) && ObjectUtil.isEmpty(reqBO.getPCodes())) {
            uocSysDictionaryDos = iUocSysDictionaryModel.qryDicList(UocRu.js(reqBO, UocSysDictionaryQryBo.class));
        }
        if (ObjectUtil.isNotEmpty(reqBO.getPCodes()) && ObjectUtil.isEmpty(reqBO.getPCode())) {
            uocSysDictionaryDos = iUocSysDictionaryModel.qryDicListByPCodes(reqBO.getPCodes());
        }
        if (ObjectUtil.isNotEmpty(uocSysDictionaryDos)) {
            rspBO.setRows(UocRu.jsl(uocSysDictionaryDos, UocProDictionaryRspDataBO.class));
        }

        return rspBO;
    }

    @Override
    public UocProDictionaryCreateRspBO createDic(UocProDictionaryCreateReqBO reqBO) {
        UocProDictionaryCreateRspBO rspBO = UocRu.success(UocProDictionaryCreateRspBO.class);
        String validateArgStr = validateCreateArg(reqBO);
        if (ObjectUtil.isNotEmpty(validateArgStr)) {
            rspBO.setRespCode(UocRspConstants.RSP_CODE_PEB_DIC_PARAM_ERROR);
            rspBO.setRespDesc("入参校验失败：" + validateArgStr);
            return rspBO;
        }
        UocSysDictionaryDo uocSysDictionaryDo = UocRu.js(reqBO, UocSysDictionaryDo.class);
        // uocSysDictionaryDo.setCreateUid(reqBO.getUserId().toString());
        uocSysDictionaryDo.setCreateTm(new Date());
        uocSysDictionaryDo.setDelFlag(UocDicConstant.DELETE_TAG.NO_DEL);
        uocSysDictionaryDo = iUocSysDictionaryModel.createDic(uocSysDictionaryDo);
        rspBO.setCode(uocSysDictionaryDo.getCode());
        rspBO.setPCode(uocSysDictionaryDo.getPCode());
        return rspBO;
    }

    @Override
    public UocProDictionaryUpdateRspBO updateDic(UocProDictionaryUpdateReqBO reqBO) {
        UocProDictionaryUpdateRspBO rspBO = UocRu.success(UocProDictionaryUpdateRspBO.class);
        String validateArgStr = validateUpdateArg(reqBO);
        if (ObjectUtil.isNotEmpty(validateArgStr)) {
            rspBO.setRespCode(UocRspConstants.RSP_CODE_PEB_DIC_PARAM_ERROR);
            rspBO.setRespDesc("入参校验失败：" + validateArgStr);
            return rspBO;
        }
        UocSysDictionaryDo uocSysDictionaryDo = UocRu.js(reqBO, UocSysDictionaryDo.class);
        // setUpdateUid(reqBO.getUserId().toString());
        uocSysDictionaryDo.setUpdateTm(new Date());
        iUocSysDictionaryModel.updateDic(uocSysDictionaryDo);
        return rspBO;
    }

    @Override
    public UocProDictionaryDeleteRspBO deleteDic(UocProDictionaryDeleteReqBO reqBO) {
        UocProDictionaryDeleteRspBO rspBO = UocRu.success(UocProDictionaryDeleteRspBO.class);
        String validateArgStr = validateDeleteArg(reqBO);
        if (ObjectUtil.isNotEmpty(validateArgStr)) {
            rspBO.setRespCode(UocRspConstants.RSP_CODE_PEB_DIC_PARAM_ERROR);
            rspBO.setRespDesc("入参校验失败：" + validateArgStr);
            return rspBO;
        }
        iUocSysDictionaryModel.deleteDic(UocRu.js(reqBO, UocSysDictionaryQryBo.class));
        return rspBO;
    }

    /**
     * 描述: 查询入参非空校验
     *
     * @param reqBo 入参
     * @return java.lang.String
     */
    private String validateQryArg(UocProDictionaryReqBO reqBo) {
        if (ObjectUtil.isNull(reqBo)) {
            return "入参对象不能为空";
        }
        if (ObjectUtil.isEmpty(reqBo.getPCode()) && ObjectUtil.isEmpty(reqBo.getPCodes())) {
            return "pCode不能为空";
        }
        return null;
    }

    /**
     * 新增入参非空校验
     *
     * @param reqBO 入参对象
     * @return String
     */
    private String validateCreateArg(UocProDictionaryCreateReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO)) {
            return "入参对象不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getPCode())) {
            return "pCode不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getCode())) {
            return "code不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getTitle())) {
            return "title不能为空";
        }
        return null;
    }

    /**
     * 更新入参非空校验
     *
     * @param reqBO 入参对象
     * @return String
     */
    private String validateUpdateArg(UocProDictionaryUpdateReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO)) {
            return "入参对象不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getPCode())) {
            return "pCode不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getCode())) {
            return "code不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getDescrip()) && ObjectUtil.isEmpty(reqBO.getTitle())
                && null == reqBO.getOrderId()) {
            return "descrip、title、orderId不能都为空";
        }
        return null;
    }

    /**
     * 删除入参非空校验
     *
     * @param reqBO 入参对象
     * @return String
     */
    private String validateDeleteArg(UocProDictionaryDeleteReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO)) {
            return "入参对象不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getPCode())) {
            return "pCode不能为空";
        }
        if (ObjectUtil.isEmpty(reqBO.getCode())) {
            return "code不能为空";
        }
        return null;
    }

}
