package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceRspConfBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单支付配置信息查询实现〉
 * @author : yuhao
 * @date : 2022/7/21 15:32
 */
@HTServiceImpl
public class UocSaleOrderPayConfQryServiceImpl implements UocSaleOrderPayConfQryService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    /**
     * 销售单支付配置查询
     */
    @Override
    public UocSaleOrderPayConfQryServiceRspBo qrySaleOrderPayConf(UocSaleOrderPayConfQryServiceReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        UocSaleOrderPayConfQryServiceRspBo rspBo = new UocSaleOrderPayConfQryServiceRspBo();
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        if(!CollectionUtils.isEmpty(saleOrderPayConfList)){
            List<UocSaleOrderPayConfQryServiceRspConfBo> uocSaleOrderPayConfQryServiceRspConfBos = JUtil.jsl(saleOrderPayConfList, UocSaleOrderPayConfQryServiceRspConfBo.class);
            rspBo.setPayConfList(uocSaleOrderPayConfQryServiceRspConfBos);
        }
        return rspBo;
    }


    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocSaleOrderPayConfQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(reqBo.getOrderId() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单Id不能为空");
        }
        if(reqBo.getSaleOrderId() == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单Id不能为空");
        }
    }
}
