package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderAddReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderAddRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocImportOrderAddServiceImpl
 * 描述：导入订单记录新增接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocImportOrderAddServiceImpl implements UocImportOrderAddService {

    /**
     * 导入订单记录领域方法服务
     */
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    /**
     * 导入订单记录新增
     */
    @Override
    public UocImportOrderAddRspBo addImportOrder(UocImportOrderAddReqBo reqBo) {
        //定义出参对象
        UocImportOrderAddRspBo rspBo = new UocImportOrderAddRspBo();

        //定义快照单DO，参数转换
        UocImportOrderDo uocSnapOrderDo = UocRu.js(reqBo, UocImportOrderDo.class);
        //设置创建人ID
        uocSnapOrderDo.setCreateUserId(String.valueOf(reqBo.getUserId()));
        //设置创建人名称
        uocSnapOrderDo.setCreateUserName(reqBo.getName());
        //设置创建机构ID
        uocSnapOrderDo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
        //设置创建机构名称
        uocSnapOrderDo.setCreateOrgName(reqBo.getOrgName());
        //设置创建公司ID
        uocSnapOrderDo.setCreateCompanyId(String.valueOf(reqBo.getCompanyId()));
        //设置创建公司名称
        uocSnapOrderDo.setCreateCompanyName(reqBo.getCompanyName());
        //设置创建机构路径
        uocSnapOrderDo.setCreateOrgPath(reqBo.getOrgPath());

        //调用导入订单记录领域方法服务，导入订单记录新增
        UocImportOrderDo uocImportOrderDo = this.iUocImportOrderModel.addImportOrder(uocSnapOrderDo);

        //出参
        rspBo.setImportOrderId(uocImportOrderDo.getImportOrderId());
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}
