package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderCheckReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderCheckRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/**
 * 标题：UocImportOrderCheckServiceImpl
 * 描述：导入订单记录校验接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocImportOrderCheckServiceImpl implements UocImportOrderCheckService {

    /**
     * 导入订单记录阈值
     */
    @Value("${uoc.importOrder.threshold:5}")
    private Integer handleThreshold;

    /**
     * 导入订单记录领域方法服务
     */
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    /**
     * 导入订单记录校验
     */
    @Override
    public UocImportOrderCheckRspBo checkImportOrder(UocImportOrderCheckReqBo reqBo) {
        //定义出参对象
        UocImportOrderCheckRspBo rspBo = new UocImportOrderCheckRspBo();

        //定义校验导入订单记录阈值量查询参数
        UocImportOrderDo checkUocImportOrderDo = new UocImportOrderDo();
        //设置状态 2执行中
        checkUocImportOrderDo.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_EXECUTION);
        //调用导入订单记录领域方法服务，校验导入订单记录阈值
        UocImportOrderDo checkImportOrderResult = this.iUocImportOrderModel.checkImportOrderThreshold(checkUocImportOrderDo);

        if (checkImportOrderResult.getCheckThreshold() > handleThreshold) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "批量下单已超过处理阈值");
        }

        //定义快照单DO，参数转换
        UocImportOrderDo updateUocImportOrderDo = new UocImportOrderDo();
        //设置记录ID
        updateUocImportOrderDo.setImportOrderId(reqBo.getImportOrderId());
        //设置状态 2执行中
        updateUocImportOrderDo.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_EXECUTION);
        //设置创建人ID
        updateUocImportOrderDo.setUpdateUserId(String.valueOf(reqBo.getUserId()));
        //设置创建人名称
        updateUocImportOrderDo.setUpdateUserName(reqBo.getName());
        //调用导入订单记录领域方法服务，导入订单记录状态修改
        this.iUocImportOrderModel.updateImportOrderInfoStatus(updateUocImportOrderDo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}
