package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceItemBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description 中化协议调价接口
 * @author Luokan
 * @date 2024/11/07
 **/

@HTServiceImpl
public class UocAdjustPriceServiceImpl implements UocAdjustPriceService{
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public UocAdjustPriceRspBO dealAdjustPrice(UocAdjustPriceReqBO reqBO) {
        UocAdjustPriceRspBO rspBO = new UocAdjustPriceRspBO();
        //查询销售单
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);

        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_1.equals(reqBO.getOperType())) {
            //供应商调价
            this.doSupAdjust(reqBO, saleOrder);
            //提交任务
            this.commitTask(reqBO);
        }
        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_2.equals(reqBO.getOperType())) {
            //运营方调价
            this.doProAdjust(reqBO, saleOrder);
            //提交任务
            this.commitTask(reqBO);
        }
        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_3.equals(reqBO.getOperType())) {
            //采购方调价
            this.doPurAdjust(reqBO, saleOrder);
            //提交任务
            this.commitTask(reqBO);
            //校验是否所有同批次订单都已流转到待审批/取消
            this.checkStartAudit(reqBO, rspBO);
        }
        return rspBO;
    }

    private void checkStartAudit(UocAdjustPriceReqBO reqBO, UocAdjustPriceRspBO rspBO) {
        //根据orderId查询所有销售单
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        Boolean allOverFlag = false;
        if (!CollectionUtils.isEmpty(saleOrderList) && saleOrderList.size() == 1) {
            allOverFlag =true;
        }else {
            allOverFlag = saleOrderList.stream().filter(bo -> bo.getSaleOrderId() != reqBO.getSaleOrderId()).allMatch(bo -> UocStateConstants.SaleOrder.XS_SP_SPZ.equals(bo.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_QX_QX.equals(bo.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_XD_SB.equals(bo.getSaleOrderState()));
        }
        if (allOverFlag) {
            //查询审批对象相表，取审批单id
            UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
            selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
            List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
            if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表为空！");
            }
            rspBO.setAuditId(uocApprovalObjs.get(0).getAuditOrderId());
            rspBO.setAuditFlowKey(saleOrderList.get(0).getAuditFlowKey());
            rspBO.setApplicationDeptId(saleOrderList.get(0).getApplicationDeptId());
            rspBO.setApplicationType(saleOrderList.get(0).getApplicationType());
            rspBO.setPurchaseMode(saleOrderList.get(0).getPurchaseMode());
            BigDecimal totalSaleFee = saleOrderList.stream().map(UocSaleOrderDo::getTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            rspBO.setTotalSaleFee(totalSaleFee);
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            BigDecimal maxGoodsSaleFee = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleFee).max(BigDecimal::compareTo).get();
            rspBO.setMaxGoodsSaleFee(maxGoodsSaleFee);
        }
    }

    private void commitTask(UocAdjustPriceReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void doPurAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!UocStateConstants.SaleOrder.XS_PUR_ADJUST.equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该状态不能进行采购调价");
        }
        //删除所有调价价格
        if (0 == reqBO.getAdjustResult()) {
            this.dealRejuectAdjust(reqBO, saleOrder);
        }else {
            //更新销售单
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
            uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
            uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
            uocSaleOrderDo.setPurAdjustConfirmTime(new Date());
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
    }

    private void doProAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!UocStateConstants.SaleOrder.XS_PRO_ADJUST.equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该状态不能进行运营调价");
        }
        //删除所有调价价格
        if (0 == reqBO.getAdjustResult()) {
            this.dealRejuectAdjust(reqBO, saleOrder);
        }else {
            //更新销售单
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
            uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
            uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
            uocSaleOrderDo.setProAdjustTime(new Date());
            if (UocDicConstant.MODEL_SETTLE.TRADE.equals(saleOrder.getModelSettle())) {
                BigDecimal totalSaleFee = saleOrder.getTotalSaleFee();
                BigDecimal totalGoodsSaleFee = saleOrder.getTotalGoodsSaleFee();
                uocSaleOrderDo.setAdjustTotalSaleFee(totalSaleFee);
                uocSaleOrderDo.setAdjustTotalGoodsSaleFee(totalGoodsSaleFee);
                BigDecimal adjustTotalSaleFee = BigDecimal.ZERO;
                //更新明细
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
                uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                Map<Long, UocAdjustPriceItemBO> adjustPriceItemMap = reqBO.getUocAdjustPriceItemBOList().stream().collect(Collectors.toMap(UocAdjustPriceItemBO::getSaleOrderItemId, Function.identity()));
                UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
                List<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<>();
                for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                    UocAdjustPriceItemBO uocAdjustPriceItemBO = adjustPriceItemMap.get(saleOrderItem.getSaleOrderItemId());
                    UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                    updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                    updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                    updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    updateSaleOrderItem.setAdjustSaleReason(uocAdjustPriceItemBO.getAdjustSaleReason());
                    updateSaleOrderItem.setAdjustSalePriceRange(uocAdjustPriceItemBO.getAdjustSalePriceRange());
                    BigDecimal salePrice = saleOrderItem.getSalePrice();
                    BigDecimal saleFee = saleOrderItem.getSaleFee();
                    updateSaleOrderItem.setAdjustSalePrice(salePrice);
                    updateSaleOrderItem.setAdjustSaleFee(saleFee);
                    BigDecimal adjustSaleFee = uocAdjustPriceItemBO.getAdjustSalePrice().multiply(saleOrderItem.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
                    updateSaleOrderItem.setSaleFee(adjustSaleFee);
                    updateSaleOrderItem.setSalePrice(uocAdjustPriceItemBO.getAdjustSalePrice());
                    updateSaleOrderItems.add(updateSaleOrderItem);
                    adjustTotalSaleFee = adjustTotalSaleFee.add(adjustSaleFee);
                }
                updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
                this.iUocSaleOrderModel.updateSaleItemWithOutSkuId(updateSaleOrderItemDo);
                uocSaleOrderDo.setTotalGoodsSaleFee(adjustTotalSaleFee);
                uocSaleOrderDo.setTotalSaleFee(adjustTotalSaleFee.add(saleOrder.getTotalTransFee()));
            }
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
    }

    private void dealRejuectAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        //更新销售单
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
        uocSaleOrderDo.setTotalTransFee(saleOrder.getAdjustTransFee());
        uocSaleOrderDo.setAdjustTransFee(null);
        uocSaleOrderDo.setAdjustTransFeeRange(null);
        uocSaleOrderDo.setAdjustTransReason(null);
        uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
        uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
        uocSaleOrderDo.setSupAdjustTime(null);
        uocSaleOrderDo.setProAdjustTime(null);
        uocSaleOrderDo.setPurAdjustConfirmTime(null);
        uocSaleOrderDo.setTotalSaleFee(saleOrder.getAdjustTotalSaleFee());
        uocSaleOrderDo.setTotalPurchaseFee(saleOrder.getAdjustTotalPurchaseFee());
        uocSaleOrderDo.setAdjustTotalSaleFee(null);
        uocSaleOrderDo.setAdjustTotalPurchaseFee(null);
        uocSaleOrderDo.setTotalGoodsSaleFee(saleOrder.getAdjustTotalGoodsSaleFee());
        uocSaleOrderDo.setTotalGoodsPurchaseFee(saleOrder.getAdjustTotalGoodsPurchaseFee());
        uocSaleOrderDo.setAdjustTotalGoodsPurchaseFee(null);
        uocSaleOrderDo.setAdjustTotalGoodsSaleFee(null);
        this.iUocSaleOrderModel.modifySaleOrderAdjust(uocSaleOrderDo);
        //更新销售明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
        List<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
            updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
            updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateSaleOrderItem.setAdjustSaleReason(null);
            updateSaleOrderItem.setAdjustSalePriceRange(null);
            updateSaleOrderItem.setAdjustPurchaseReason(null);
            updateSaleOrderItem.setAdjustPurchasePriceRange(null);
            updateSaleOrderItem.setPurchasePrice(saleOrderItem.getAdjustPurchasePrice());
            updateSaleOrderItem.setSalePrice(saleOrderItem.getAdjustSalePrice());
            updateSaleOrderItem.setAdjustSalePrice(null);
            updateSaleOrderItem.setAdjustPurchasePrice(null);
            updateSaleOrderItem.setPurchaseFee(saleOrderItem.getAdjustPurchaseFee());
            updateSaleOrderItem.setSaleFee(saleOrderItem.getAdjustSaleFee());
            updateSaleOrderItem.setAdjustSaleFee(null);
            updateSaleOrderItem.setAdjustPurchaseFee(null);
            updateSaleOrderItems.add(updateSaleOrderItem);
        }
        updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
        this.iUocSaleOrderModel.updateSaleItemAdjust(updateSaleOrderItemDo);
    }

    private void doSupAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!UocStateConstants.SaleOrder.XS_SUP_ADJUST.equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "该状态不能进行供应商调价");
        }
        //更新销售单
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
        BigDecimal totalTransFee = saleOrder.getTotalTransFee();
        uocSaleOrderDo.setTotalTransFee(reqBO.getAdjustTransFee());
        uocSaleOrderDo.setAdjustTransFee(totalTransFee);
        uocSaleOrderDo.setAdjustTransFeeRange(reqBO.getAdjustTransFeeRange());
        uocSaleOrderDo.setAdjustTransReason(reqBO.getAdjustTransReason());
        uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
        uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
        uocSaleOrderDo.setSupAdjustTime(new Date());
        BigDecimal totalPurchaseFee = saleOrder.getTotalPurchaseFee();
        BigDecimal totalGoodsPurchaseFee = saleOrder.getTotalGoodsPurchaseFee();
        uocSaleOrderDo.setAdjustTotalPurchaseFee(totalPurchaseFee);
        uocSaleOrderDo.setAdjustTotalGoodsPurchaseFee(totalGoodsPurchaseFee);
        if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
            uocSaleOrderDo.setAdjustTotalSaleFee(totalPurchaseFee);
            uocSaleOrderDo.setAdjustTotalGoodsSaleFee(totalGoodsPurchaseFee);
        }
        BigDecimal adjustTotalPurchaseFee = BigDecimal.ZERO;
        //更新明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocAdjustPriceItemBO> adjustPriceItemMap = reqBO.getUocAdjustPriceItemBOList().stream().collect(Collectors.toMap(UocAdjustPriceItemBO::getSaleOrderItemId, Function.identity()));
        UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
        List<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocAdjustPriceItemBO uocAdjustPriceItemBO = adjustPriceItemMap.get(saleOrderItem.getSaleOrderItemId());
            UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
            updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
            updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateSaleOrderItem.setAdjustPurchaseReason(uocAdjustPriceItemBO.getAdjustPurchaseReason());
            updateSaleOrderItem.setAdjustPurchasePriceRange(uocAdjustPriceItemBO.getAdjustPurchasePriceRange());
            BigDecimal purchasePrice = saleOrderItem.getPurchasePrice();
            BigDecimal purchaseFee = saleOrderItem.getPurchaseFee();
            updateSaleOrderItem.setAdjustPurchasePrice(purchasePrice);
            updateSaleOrderItem.setAdjustPurchaseFee(purchaseFee);
            if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
                updateSaleOrderItem.setAdjustSalePrice(purchasePrice);
                updateSaleOrderItem.setAdjustSaleFee(purchaseFee);
                updateSaleOrderItem.setAdjustSaleReason(uocAdjustPriceItemBO.getAdjustPurchaseReason());
                updateSaleOrderItem.setAdjustSalePriceRange(uocAdjustPriceItemBO.getAdjustPurchasePriceRange());
            }
            BigDecimal adjustPurchseFee = uocAdjustPriceItemBO.getAdjustPurchasePrice().multiply(saleOrderItem.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
            updateSaleOrderItem.setPurchaseFee(adjustPurchseFee);
            updateSaleOrderItem.setPurchasePrice(uocAdjustPriceItemBO.getAdjustPurchasePrice());
            if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
                updateSaleOrderItem.setSaleFee(adjustPurchseFee);
                updateSaleOrderItem.setSalePrice(uocAdjustPriceItemBO.getAdjustPurchasePrice());
            }
            updateSaleOrderItems.add(updateSaleOrderItem);
            adjustTotalPurchaseFee = adjustTotalPurchaseFee.add(adjustPurchseFee);
        }
        updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
        this.iUocSaleOrderModel.updateSaleItemWithOutSkuId(updateSaleOrderItemDo);
        uocSaleOrderDo.setTotalGoodsPurchaseFee(adjustTotalPurchaseFee);
        uocSaleOrderDo.setTotalPurchaseFee(adjustTotalPurchaseFee.add(reqBO.getAdjustTransFee()));
        if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
            uocSaleOrderDo.setTotalGoodsSaleFee(adjustTotalPurchaseFee);
            uocSaleOrderDo.setTotalSaleFee(adjustTotalPurchaseFee.add(reqBO.getAdjustTransFee()));
        }
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }
}
