package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqSkuBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-电商预定单下单成功处理服务 实现〉
 *
 * @author : lihulin
 * @date : 2024/06/28 17:18
 */
@Slf4j
@Component
public class UocResoveEsPreOrderTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Value("${dyc.system.name:DYC}")
    private String systemName;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = UocRu.success(UocResoveEsPreOrderServiceRspBo.class);

        if (!CollectionUtils.isEmpty(reqBo.getSku())) {
            // 更新销售单item裸价，税率，税金
            UocSaleOrderDo updatSaleItemBo = assembleUpdateDo(reqBo);
            iUocSaleOrderModel.updateSaleItemWithOutSkuId(updatSaleItemBo);
        }

        if(UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())){
            UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_XD_SB);
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);
            //校验改订单下所有销售单是否都已经取消/失败，如果是则更新审批流。
            //根据orderId查询所有销售单
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
            List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
            Boolean allOverFlag = saleOrderList.stream().allMatch(bo -> UocStateConstants.SaleOrder.XS_QX_QX.equals(bo.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_XD_SB.equals(bo.getSaleOrderState()));
            if (allOverFlag) {
                UocOrderDo updateOrder = new UocOrderDo();
                updateOrder.setOrderId(reqBo.getOrderId());
                updateOrder.setOrderState("3");
                updateOrder.setDelTag(1);
                this.iUocOrderModel.updateOrderState(updateOrder);
            }
            //北控，罗侃已确认bug修改
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setSaleOrderId(reqBo.getSaleOrderId());
            rspBo.setOutOrderId(reqBo.getOutOrderId());
            return rspBo;
        }else {
            //根据orderId查询所有销售单
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderQryBo.setOrderSource(UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT);
            List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
            Boolean aduitFlag = false;
            if (!CollectionUtils.isEmpty(saleOrderList) && saleOrderList.size() == 1) {
                aduitFlag = true;
            } else{
                //排除掉当前销售单
                List<UocSaleOrderDo> saleOrderExeistSelfList = saleOrderList.stream().filter(bo -> bo.getSaleOrderId() != reqBo.getSaleOrderId() && !(UocStateConstants.SaleOrder.XS_QX_QX.equals(bo.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_XD_SB.equals(bo.getSaleOrderState()))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(saleOrderExeistSelfList)) {
                    aduitFlag = saleOrderExeistSelfList.stream().allMatch(bo -> UocStateConstants.SaleOrder.XS_SP_SPZ.equals(bo.getSaleOrderState()));
                }
            }
            if (aduitFlag) {
                //查询审批对象相表，取审批单id
                UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                selectuocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
                List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
                if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表为空！");
                }
                rspBo.setAuditId(uocApprovalObjs.get(0).getAuditOrderId());
                rspBo.setAuditFlowKey(saleOrderList.get(0).getAuditFlowKey());
                rspBo.setApplicationDeptId(saleOrderList.get(0).getApplicationDeptId());
                rspBo.setApplicationType(saleOrderList.get(0).getApplicationType());
                rspBo.setPurchaseMode(saleOrderList.get(0).getPurchaseMode());
                BigDecimal totalSaleFee = saleOrderList.stream().map(UocSaleOrderDo::getTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                rspBo.setTotalSaleFee(totalSaleFee);
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                BigDecimal maxGoodsSaleFee = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleFee).max(BigDecimal::compareTo).get();
                rspBo.setMaxGoodsSaleFee(maxGoodsSaleFee);
            }
        }

        /*// 更新销售单item裸价，税率，税金
        UocSaleOrderDo updatSaleItemBo = assembleUpdateDo(reqBo);
        iUocSaleOrderModel.updateSaleItemWithOutSkuId(updatSaleItemBo);*/

        // 更新销售单表外部订单id
        UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
        updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
        updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
        updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
        iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);

        // 保存外部订单id和内部订单关系
        UocOrderQueryIndex index = new UocOrderQueryIndex();
        index.setId(IdUtil.nextId());
        index.setOrderId(reqBo.getOrderId());
        index.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        index.setObjId(reqBo.getSaleOrderId());
        index.setOutObjId(reqBo.getOutOrderId());
        iUocCommonModel.saveOrderQueryIndex(index);

        //出参
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());

        return rspBo;
    }

    private UocSaleOrderDo assembleUpdateDo(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocSaleOrderDo updateSaleItemBo = new UocSaleOrderDo();
        updateSaleItemBo.setOrderId(reqBo.getOrderId());
        updateSaleItemBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocResoveEsPreOrderServiceReqSkuBo> sku = reqBo.getSku();
        List<UocSaleOrderItem> saleItemList = new ArrayList<>();
        updateSaleItemBo.setSaleOrderItems(saleItemList);
        for (UocResoveEsPreOrderServiceReqSkuBo skuBo : sku) {
            UocSaleOrderItem item = new UocSaleOrderItem();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());

            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            item.setFailReason(skuBo.getFailReason());
            saleItemList.add(item);
        }
        return updateSaleItemBo;
    }
}
