package com.tydic.dyc.pro.base.bo.esmapping;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：DycProEsIndexMappingShipOrderItemBO
 * 描述：发货单明细索引映射
 */
@Data
public class DycProEsIndexMappingInspOrderItemBO implements Serializable {

    private static final long serialVersionUID = 35833645325216067L;
    /**
     * 验收明细id
     */
    private Long inspOrderItemId;
    /**
     * 发货明细id
     */
    private Long shipOrderItemId;
    /**
     * 发货单id
     */
    private Long shipOrderId;
    /**
     * 发货单编码
     */
    private String shipOrderNo;
    /**
     * 销售明细id
     */
    private Long saleOrderItemId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * sku外部单品id
     */
    private String skuExtSkuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 销售金额
     */
    private BigDecimal salePrice;
    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;
    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;
    /**
     * 验收数量
     */
    private BigDecimal inspCount;
    /**
     * 异常变更在途数量
     */
    private BigDecimal chngingCount;
    /**
     * 商品销售总金额
     */
    private BigDecimal totalSaleFee;
    /**
     * 商品采购总金额
     */
    private BigDecimal totalPurchaseFee;
    /**
     * 验收单销售总金额
     */
    private BigDecimal inspTotalSaleFee;
    /**
     * 验收单采购总金额
     */
    private BigDecimal inspTotalPurchaseFee;
    /**
     * sku物料编码
     */
    private String skuMaterialCode;
    /**
     * sku物料名称
     */
    private String skuMaterialName;
    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;
    /**
     * 计量单位
     */
    private String unitName;
    /**
     * 税率
     */
    private BigDecimal tax;
    /**
     * 计量单位位数
     */
    private String unitDigit;
    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;
    /**
     * 价格指数
     */
    private BigDecimal referencePrice;
    /**
     * 价格指数比例
     */
    private BigDecimal referencePriceRate;
    /**
     * M码
     */
    private String mCode;
    /**
     * M名称
     */
    private String mName;
    /**
     * 专业公司物料组编码
     */
    private String majorCompanyCatalogCode;
    /**
     * 标准商品编码
     */
    private String upcCode;
    /**
     * 协议id
     */
    private String agreementId;
    /**
     * 协议名称
     */
    private String agreementName;
}
