package com.tydic.dyc.pro.base.core.contentreview.bo;


import lombok.Builder;
import lombok.Data;


import java.io.Serializable;
/**
 * @Author HeDengHui
 * @Date 2025/5/30 12.51
 * @Description:ImageScanTaskBO
 **/
@Data
public class DycProContentReviewImageScanTaskBO implements Serializable {

    private static final long serialVersionUID = -1686164937896367237L;
    /**
     * 图片创建或编辑时间，单位为毫秒
     */
    private Long imageTimeMillisecond;
    /**
     *截帧频率，GIF图或者长图检测专用。GIF图可理解为图片数组，
     * 每interval张图片抽取一张进行检测。
     * 只有该值存在时，才会对GIF进行截帧。长图同时支持长竖图和长横图。
     */
    private Integer interval;
    /**
     * 待检测图像的URL地址。支持HTTP和HTTPS协议。
     * 此项必传，其它可选
     */
    private String imageURL;
    /**
     * 最大截帧数量，GIF图或长图检测专用，默认值为1。
     */
    private Integer maxFrames;
    /**
     * 数据ID
     */
    private String dataId;

}
