package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @Author HeDenghui
 * @Date 2025/8/15 15:43
 * @Description:
 */
public enum ZLEgcPurApplyItemStatus implements DictionaryEnum{

    /**
     * 待匹配：PENDING_MATCH
     */
    PENDING_MATCH("PUR_APPLY_ITEM_STATUS", "1", "待匹配", "采购申请明细状态"),

    /**
     * 已匹配：MATCHED
     */
    MATCHED("PUR_APPLY_ITEM_STATUS", "2", "已匹配", "采购申请明细状态"),

    /**
     * 已下单：ORDERED
     */
    ORDERED("PUR_APPLY_ITEM_STATUS", "3", "已下单", "采购申请明细状态"),

    /**
     * 已终止：TERMINATED
     */
    TERMINATED("PUR_APPLY_ITEM_STATUS", "4", "已终止", "采购申请明细状态");
    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    ZLEgcPurApplyItemStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
