package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * @Author HeDenghui
 * @Date 2025/8/15 15:30
 * @Description:
 */
public enum ZLEgcPurApplyStatus implements DictionaryEnum{
    /**
     * 草稿：DRAFT
     */
    DRAFT("PUR_APPLY_STATUS", "1", "草稿", "采购申请状态"),

    /**
     * 审批中：APPROVING
     */
    APPROVING("PUR_APPLY_STATUS", "2", "审批中", "采购申请状态"),

    /**
     * 待执行：PENDING
     */
    PENDING("PUR_APPLY_STATUS", "3", "待执行", "采购申请状态"),

    /**
     * 执行中：EXECUTING
     */
    EXECUTING("PUR_APPLY_STATUS", "4", "执行中", "采购申请状态"),

    /**
     * 已执行：EXECUTED
     */
    EXECUTED("PUR_APPLY_STATUS", "5", "已执行", "采购申请状态"),

    /**
     * 已驳回：REJECTED
     */
    REJECTED("PUR_APPLY_STATUS", "6", "已驳回", "采购申请状态"),

    /**
     * 已终止：TERMINATED
     */
    TERMINATED("PUR_APPLY_STATUS", "7", "已终止", "采购申请状态");


    /**
     * 编码
     */
    private final String dictionaryCode;
    /**
     * 编码
     */
    private final String code;
    /**
     * 编码值
     */
    private final String value;
    /**
     * 名称
     */
    private final String dictionaryName;

    ZLEgcPurApplyStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
