package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议确认申请类型 枚举
 *
 * @author lihulin
 */
public enum DmcAgrConfirmType implements DictionaryEnum {
    CREATE("DMC_AGR_CONFIRM_TYPE", "1", "协议新增", "协议确认申请类型"),
    CHANGE("DMC_AGR_CONFIRM_TYPE", "2", "协议变更", "协议确认申请类型");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrConfirmType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
