package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议状态 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainAgrStatus implements DictionaryEnum {
    DRAFT("DMC_AGR_MAIN_AGR_STATUS", "0", "草稿", "协议状态"),
    PENDING_REVIEW("DMC_AGR_MAIN_AGR_STATUS", "1", "确认中", "协议状态"),
    NOT_ACCEPTED("DMC_AGR_MAIN_AGR_STATUS", "2", "未接受", "协议状态"),
    APPROVAL("DMC_AGR_MAIN_AGR_STATUS", "3", "审批中", "协议状态"),
    REJECTED("DMC_AGR_MAIN_AGR_STATUS", "4", "已驳回", "协议状态"),
    PENDING_EFFECTIVE("DMC_AGR_MAIN_AGR_STATUS", "5", "待生效", "协议状态"),
    SUSPENDED("DMC_AGR_MAIN_AGR_STATUS", "6", "暂停", "协议状态"),
    ACTIVE("DMC_AGR_MAIN_AGR_STATUS", "7", "启用", "协议状态"),
    EXPIRED("DMC_AGR_MAIN_AGR_STATUS", "8", "过期", "协议状态"),
    TERMINATED("DMC_AGR_MAIN_AGR_STATUS", "9", "终止", "协议状态"),
    FREEZE("DMC_AGR_MAIN_AGR_STATUS", "10", "冻结", "协议状态"),
    HISTORY("DMC_AGR_MAIN_AGR_STATUS", "99", "历史", "协议状态");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainAgrStatus(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
