package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 铺货单位 枚举
 *
 * @author lihulin
 */

public enum DmcAgrMainVendorMode implements DictionaryEnum {
    YYPH("DMC_AGR_MAIN_VENDOR_MODE", "1", "运营单位", "铺货单位"),
    GYSPH("DMC_AGR_MAIN_VENDOR_MODE", "2", "供应商", "铺货单位"),
    CGPH("DMC_AGR_MAIN_VENDOR_MODE", "3", "采购单位", "铺货单位");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrMainVendorMode(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
