/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.base.core.contentreview.impl;

import com.aliyun.imageaudit20191230.Client;
import com.aliyun.imageaudit20191230.models.ScanTextRequest;
import com.aliyun.imageaudit20191230.models.ScanTextResponse;
import com.aliyun.imageaudit20191230.models.ScanTextResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunTextScanService;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanReqBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanRspBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanSubResultBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProContentReviewAliyunTextScanServiceImpl
implements DycProContentReviewAliyunTextScanService {
    private static final Logger log = LoggerFactory.getLogger(DycProContentReviewAliyunTextScanServiceImpl.class);
    @Autowired
    private Client aliyunClient;

    @Override
    public DycProContentReviewTextScanRspBO textScan(DycProContentReviewTextScanReqBO reqBO) {
        ScanTextResponse scanTextResponse;
        this.textScanParamVerify(reqBO);
        ScanTextRequest scanTextRequest = this.getTextScanRequest(reqBO);
        RuntimeOptions runtimeOptions = new RuntimeOptions();
        try {
            Date start = new Date();
            scanTextResponse = this.aliyunClient.scanTextWithOptions(scanTextRequest, runtimeOptions);
            Date end = new Date();
            log.info("\u6587\u5b57\u68c0\u6d4b\u603b\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()));
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91API\u8c03\u7528\u6587\u5b57\u76d1\u6d4b\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u963f\u91cc\u4e91\u8c03\u7528\u6587\u5b57\u76d1\u6d4b\u5931\u8d25" + e.getMessage());
        }
        DycProContentReviewTextScanRspBO resultsBO = new DycProContentReviewTextScanRspBO();
        if (scanTextResponse != null && 200 == scanTextResponse.statusCode && scanTextResponse.getBody() != null) {
            log.info("\u56fe\u7247\u68c0\u6d4brequestId\uff1a" + scanTextResponse.getBody().getRequestId());
            resultsBO.setRequestId(scanTextResponse.getBody().getRequestId());
            if (scanTextResponse.getBody().getData() != null && scanTextResponse.getBody().getData().getElements() != null) {
                List<String> originalContents = reqBO.getContent();
                ArrayList<DycProContentReviewTextScanSubResultBO> allResults = new ArrayList<DycProContentReviewTextScanSubResultBO>();
                for (int i = 0; i < scanTextResponse.getBody().getData().getElements().size(); ++i) {
                    ScanTextResponseBody.ScanTextResponseBodyDataElements element = (ScanTextResponseBody.ScanTextResponseBodyDataElements)scanTextResponse.getBody().getData().getElements().get(i);
                    String originalContent = i < originalContents.size() ? originalContents.get(i) : "";
                    List<Object> resultsList = null;
                    resultsList = element.getResults() != null ? element.getResults().stream().map(result -> {
                        DycProContentReviewTextScanSubResultBO resultBO = new DycProContentReviewTextScanSubResultBO();
                        resultBO.setSuggestion(result.getSuggestion());
                        resultBO.setLabel(result.getLabel());
                        resultBO.setRate(result.getRate().floatValue());
                        resultBO.setContent(originalContent);
                        List<String> contextList = null;
                        contextList = result.getDetails() != null ? result.getDetails().stream().filter(detail -> detail.getContexts() != null).flatMap(detail -> detail.getContexts().stream()).map(ScanTextResponseBody.ScanTextResponseBodyDataElementsResultsDetailsContexts::getContext).collect(Collectors.toList()) : new ArrayList<String>();
                        resultBO.setContexts(contextList);
                        return resultBO;
                    }).collect(Collectors.toList()) : new ArrayList();
                    allResults.addAll(resultsList);
                }
                resultsBO.setResults(allResults);
            } else {
                log.info("\u6587\u5b57\u68c0\u6d4b\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                resultsBO.setResults(new ArrayList<DycProContentReviewTextScanSubResultBO>());
            }
        } else {
            log.info("\u6587\u5b57\u68c0\u6d4b\u5931\u8d25\uff0c\u65e0\u5185\u5bb9");
            return null;
        }
        return resultsBO;
    }

    private void textScanParamVerify(DycProContentReviewTextScanReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getContent())) {
            throw new ZTBusinessException("\u68c0\u67e5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getLabels())) {
            throw new ZTBusinessException("\u68c0\u67e5\u6307\u6807\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private ScanTextRequest getTextScanRequest(DycProContentReviewTextScanReqBO reqBO) {
        ScanTextRequest scanTextRequest = new ScanTextRequest();
        List<Object> sdkTasks = new ArrayList();
        sdkTasks = reqBO.getContent().stream().map(t -> new ScanTextRequest.ScanTextRequestTasks().setContent(t)).collect(Collectors.toList());
        List<Object> sdkLabels = new ArrayList();
        sdkLabels = reqBO.getLabels().stream().map(l -> new ScanTextRequest.ScanTextRequestLabels().setLabel(l)).collect(Collectors.toList());
        scanTextRequest.setTasks(sdkTasks);
        scanTextRequest.setLabels(sdkLabels);
        return scanTextRequest;
    }
}

