package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 标题：DmcCommManageCatalogInfoMaterialType
 * 说明：物料类型
 * 时间：2025/08/11 11:13
 *
 * @author lihulin
 **/
public enum DmcCommManageCatalogInfoMaterialType implements DictionaryEnum {
    FEE("MATERIAL_TYPE", "1", "费用类", "物料类型"),
    ORDER("MATERIAL_TYPE", "2", "订单类", "物料类型");

    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcCommManageCatalogInfoMaterialType(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
